<?php
/**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with OrangeHRM.
 * If not, see <https://www.gnu.org/licenses/>.
 */

namespace OrangeHRM\Tests\LDAP\Dto;

use OrangeHRM\LDAP\Dto\LDAPEmployeeSelectorMapping;
use OrangeHRM\LDAP\Dto\LDAPUser;
use OrangeHRM\LDAP\Dto\LDAPUserLookupSetting;
use OrangeHRM\Tests\Util\TestCase;

/**
 * @group Admin
 * @group LDAP
 * @group Dto
 */
class LDAPUserTest extends TestCase
{
    public function testLDAPUser(): void
    {
        $ldapUser = new LDAPUser();
        $ldapUser->setUserDN('uid=Linda.Anderson,ou=admin,ou=users,dc=example,dc=org');
        $ldapUser->setUsername('Linda.Anderson');
        $ldapUser->setUserUniqueId('e12bb022-c1f4-103c-802e-d9f8f9ce8904');
        $ldapUser->setFirstName('Linda');
        $ldapUser->setLastName('Anderson');
        $ldapUser->setWorkEmail('linda@example.org');
        $ldapUser->setEmployeeId('0001');

        $this->assertEquals(
            '4f3a32373a224f72616e676548524d5c4c4441505c44746f5c4c44415055736572223a393a7b733a33353a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572444e223b733a35343a227569643d4c696e64612e416e646572736f6e2c6f753d61646d696e2c6f753d75736572732c64633d6578616d706c652c64633d6f7267223b733a33373a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200757365726e616d65223b733a31343a224c696e64612e416e646572736f6e223b733a34313a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572556e697175654964223b733a33363a2265313262623032322d633166342d313033632d383032652d643966386639636538393034223b733a34303a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572456e61626c6564223b623a313b733a33383a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720066697273744e616d65223b733a353a224c696e6461223b733a33393a22004f72616e676548524d5c4c4441505c44746f5c4c44415055736572006d6964646c654e616d65223b733a303a22223b733a33373a22004f72616e676548524d5c4c4441505c44746f5c4c44415055736572006c6173744e616d65223b733a383a22416e646572736f6e223b733a33393a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200656d706c6f7965654964223b733a343a2230303031223b733a33383a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200776f726b456d61696c223b733a31373a226c696e6461406578616d706c652e6f7267223b7d',
            bin2hex(serialize($ldapUser))
        );
    }

    public function testLDAPUserWithLookupSetting(): void
    {
        $ldapUser = new LDAPUser();
        $ldapUser->setUserDN('uid=Linda.Anderson,ou=admin,ou=users,dc=example,dc=org');
        $ldapUser->setUsername('Linda.Anderson');
        $ldapUser->setUserUniqueId('e12bb022-c1f4-103c-802e-d9f8f9ce8904');
        $ldapUser->setFirstName('Linda');
        $ldapUser->setLastName('Anderson');
        $ldapUser->setWorkEmail('linda@example.org');
        $ldapUser->setEmployeeId('0001');

        $userLookupSetting = new LDAPUserLookupSetting('ou=admin,ou=users,dc=example,dc=org');
        $ldapUser->setUserLookupSetting($userLookupSetting);

        $this->assertEquals(
            '4f3a32373a224f72616e676548524d5c4c4441505c44746f5c4c44415055736572223a31303a7b733a33353a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572444e223b733a35343a227569643d4c696e64612e416e646572736f6e2c6f753d61646d696e2c6f753d75736572732c64633d6578616d706c652c64633d6f7267223b733a33373a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200757365726e616d65223b733a31343a224c696e64612e416e646572736f6e223b733a34313a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572556e697175654964223b733a33363a2265313262623032322d633166342d313033632d383032652d643966386639636538393034223b733a34303a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720075736572456e61626c6564223b623a313b733a33383a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365720066697273744e616d65223b733a353a224c696e6461223b733a33393a22004f72616e676548524d5c4c4441505c44746f5c4c44415055736572006d6964646c654e616d65223b733a303a22223b733a33373a22004f72616e676548524d5c4c4441505c44746f5c4c44415055736572006c6173744e616d65223b733a383a22416e646572736f6e223b733a33393a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200656d706c6f7965654964223b733a343a2230303031223b733a33383a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200776f726b456d61696c223b733a31373a226c696e6461406578616d706c652e6f7267223b733a34363a22004f72616e676548524d5c4c4441505c44746f5c4c4441505573657200757365724c6f6f6b757053657474696e67223b4f3a34303a224f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e67223a363a7b733a34383a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e670062617365444e223b733a33353a226f753d61646d696e2c6f753d75736572732c64633d6578616d706c652c64633d6f7267223b733a35333a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e670073656172636853636f7065223b733a333a22737562223b733a35393a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e6700757365724e616d65417474726962757465223b733a323a22636e223b733a36333a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e670075736572556e697175654964417474726962757465223b733a393a22656e74727955554944223b733a35383a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e67007573657253656172636846696c746572223b733a32373a22286f626a656374436c6173733d696e65744f7267506572736f6e29223b733a36353a22004f72616e676548524d5c4c4441505c44746f5c4c444150557365724c6f6f6b757053657474696e6700656d706c6f79656553656c6563746f724d617070696e67223b4f3a34363a224f72616e676548524d5c4c4441505c44746f5c4c444150456d706c6f79656553656c6563746f724d617070696e67223a313a7b733a31333a22002a00706172616d6574657273223b613a303a7b7d7d7d7d',
            bin2hex(serialize($ldapUser))
        );

        $userLookupSetting = new LDAPUserLookupSetting('ou=admin,ou=users,dc=example,dc=org');
        $employeeSelectorMapping = LDAPEmployeeSelectorMapping::createFromArray(
            [['field' => 'workEmail', 'attributeName' => 'mail']]
        );
        $userLookupSetting->setEmployeeSelectorMapping($employeeSelectorMapping);
        $ldapUser->setUserLookupSetting($userLookupSetting);

        $this->assertEquals(
            '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',
            bin2hex(serialize($ldapUser))
        );
    }
}
