# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import collections
import json
import unittest

from petstore_api import api_client, exceptions, schemas, rest

ParamTestCase = collections.namedtuple('ParamTestCase', 'payload expected_serialization')

class MediaType(api_client.MediaType):
    schema=schemas.AnyTypeSchema

class TestParameter(unittest.TestCase):
    def test_content_json_serialization(self):
        payloads = [
            None,
            1,
            3.14,
            'blue',
            'hello world',
            '',
            True,
            False,
            [],
            ['blue', 'black', 'brown'],
            {},
            dict(R=100, G=200, B=150),
        ]
        for payload in payloads:
            class RequestBody(api_client.RequestBody):
                content = {
                    'application/json': MediaType
                }

            serialization = RequestBody.serialize(payload, 'application/json')
            self.assertEqual(
                serialization,
                dict(body=json.dumps(payload, separators=(",", ":"), ensure_ascii=False).encode('utf-8'))
            )

    def test_content_multipart_form_data_serialization(self):
        payload = dict(
            some_null=None,
            some_bool=True,
            some_str='a',
            some_int=1,
            some_float=3.14,
            some_list=[],
            some_dict={},
            some_bytes=b'abc'
        )
        class RequestBody(api_client.RequestBody):
            content={'multipart/form-data': MediaType}

        serialization = RequestBody.serialize(payload, 'multipart/form-data')
        self.assertEqual(
            serialization,
            dict(
                fields=(
                    rest.RequestField(
                        name='some_null', data='null', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_null\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_bool', data='true', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_bool\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_str', data='a', headers={
                            'Content-Type': 'text/plain',
                            "Content-Disposition": "form-data; name=\"some_str\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_int', data='1', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_int\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_float', data='3.14', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_float\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_list', data='[]', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_list\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_dict', data='{}', headers={
                            'Content-Type': 'application/json',
                            "Content-Disposition": "form-data; name=\"some_dict\"",
                            "Content-Location": None
                        }),
                    rest.RequestField(
                        name='some_bytes', data=b'abc', headers={
                            'Content-Type': 'application/octet-stream',
                            "Content-Disposition": "form-data; name=\"some_bytes\"",
                            "Content-Location": None
                        })
                )
            )
        )

    def test_throws_error_for_nonexistant_content_type(self):
        class RequestBody(api_client.RequestBody):
            content={'application/json': MediaType}

        with self.assertRaises(KeyError):
            RequestBody.serialize(None, 'abc/def')

    def test_throws_error_for_not_implemented_content_type(self):
        class RequestBody(api_client.RequestBody):
            content={
                'application/json': MediaType,
                'text/css': MediaType
            }

        with self.assertRaises(NotImplementedError):
            RequestBody.serialize(None, 'text/css')

    def test_application_x_www_form_urlencoded_serialization(self):
        payload = dict(
            some_null=None,
            some_str='hi there',
            some_int=1,
            some_float=3.14,
            some_list=[],
            some_dict={},
        )
        content_type = 'application/x-www-form-urlencoded'
        class RequestBody(api_client.RequestBody):
            content={content_type: MediaType}

        serialization = RequestBody.serialize(payload, content_type)
        self.assertEqual(
            serialization,
            dict(body='some_str=hi%20there&some_int=1&some_float=3.14')
        )

        serialization = RequestBody.serialize({}, content_type)
        self.assertEqual(
            serialization,
            dict(body='')
        )

        invalid_payloads = [
            dict(some_bool=True),
            dict(some_bytes=b'abc'),
            dict(some_list_with_data=[0]),
            dict(some_dict_with_data={'a': 'b'}),
        ]
        for invalid_payload in invalid_payloads:
            with self.assertRaises(exceptions.ApiValueError):
                RequestBody.serialize(invalid_payload, content_type)


if __name__ == '__main__':
    unittest.main()
