# coding: utf-8

"""


    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import json
import unittest
from unittest.mock import patch

import urllib3

from petstore_api.paths.pet_pet_id.get import operation as get
from petstore_api import schemas, api_client
from petstore_api.configurations import api_configuration
from petstore_api.components.schema import pet

from ... import ApiTestMixin


class TestPetPetId(ApiTestMixin, unittest.TestCase):
    """
    PetPetId unit test stubs
        Find pet by ID  # noqa: E501
    """
    def test_get(self):
        security_scheme_info = api_configuration.SecuritySchemeInfo(
            api_key=api_configuration.security_scheme_api_key.ApiKey(
                api_key='someKey'
            )
        )
        config_with_auth = api_configuration.ApiConfiguration(security_scheme_info=security_scheme_info)
        used_api_client = api_client.ApiClient(configuration=config_with_auth)
        api = get.ApiForGet(api_client=used_api_client)

        with patch.object(urllib3.PoolManager, 'request') as mock_request:
            response_json = {
                'photoUrls': [],
                'name': 'Kitty',
                'id': 1,
                'category': {
                    'name': 'Cat',
                    'id': 1
                },
                'tags': [],
                'status': 'available'
            }
            body = self.json_bytes(response_json)
            mock_request.return_value = self.response(body)

            api_response = api.get(path_params={'petId': 1})
            self.assert_pool_manager_request_called_with(
                mock_request,
                'http://petstore.swagger.io:80/v2/pet/1',
                body=None,
                method='GET',
                content_type=None,
                accept_content_type='application/xml, application/json',
                headers={'api_key': 'someKey'}
            )

            assert isinstance(api_response.response, urllib3.HTTPResponse)
            assert isinstance(api_response.body, pet.PetDict)
            assert isinstance(api_response.headers, schemas.Unset)
            assert api_response.response.status == 200


if __name__ == '__main__':
    unittest.main()
