# coding: utf-8

"""


    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest
from unittest.mock import patch

import urllib3

from petstore_api.paths.fake_redirection.get import operation as get  # noqa: E501
from petstore_api import schemas, api_client
from petstore_api.configurations import api_configuration, schema_configuration

from ... import ApiTestMixin


class TestGet(ApiTestMixin, unittest.TestCase):
    """
    Get unit test stubs
        operation with redirection responses  # noqa: E501
    """
    api_config = api_configuration.ApiConfiguration()
    schema_config = schema_configuration.SchemaConfiguration()
    used_api_client = api_client.ApiClient(configuration=api_config, schema_configuration=schema_config)
    api = get.ApiForGet(api_client=used_api_client)  # noqa: E501

    @patch.object(urllib3.PoolManager, 'request')
    def test_non_wildcard_response(self, mock_request):
        mock_request.return_value = self.response(b'', status=303)

        api_response = self.api.get()
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake/redirection',
            body=None,
            method='GET',
            content_type=None,
            accept_content_type=None,
        )

        assert isinstance(api_response, get.response_303.ApiResponse)
        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 303

    @patch.object(urllib3.PoolManager, 'request')
    def test_wildcard_response(self, mock_request):
        mock_request.return_value = self.response(b'', status=308)

        api_response = self.api.get()
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake/redirection',
            body=None,
            method='GET',
            content_type=None,
            accept_content_type=None,
        )

        assert isinstance(api_response, get.response_3xx.ApiResponse)
        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 308

if __name__ == '__main__':
    unittest.main()
