# coding: utf-8

"""


    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest
from unittest.mock import patch

import urllib3

from petstore_api.paths.fake.get import operation as get  # noqa: E501
from petstore_api import schemas, api_client, exceptions
from urllib3 import _collections

from ... import ApiTestMixin


class TestFake(ApiTestMixin, unittest.TestCase):
    """
    Fake unit test stubs
        To test enum parameters  # noqa: E501
    """
    used_api_client = api_client.ApiClient(
        default_headers=_collections.HTTPHeaderDict({
            'enum_header_string': '_abc'
        })
    )

    @patch.object(urllib3.PoolManager, 'request')
    def test_passed_in_header_overrides_default(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        header_params: get.HeaderParametersDictInput = {'enum_header_string': '-efg'}
        api_response = api.get(header_params=header_params)
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake',
            body=None,
            method='GET',
            content_type=None,
            accept_content_type='application/json',
            headers={'enum_header_string': '-efg'}
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200

    @patch.object(urllib3.PoolManager, 'request')
    def test_default_header_used_when_no_header_params_input(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        api_response = api.get()
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake',
            body=None,
            method='GET',
            content_type=None,
            accept_content_type='application/json',
            headers={'enum_header_string': '_abc'}
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200

    @patch.object(urllib3.PoolManager, 'request')
    def test_response_exception_info(self, mock_request):
        error_dict = {
            'msg': 'record not found'
        }
        response_body_bytes = self.json_bytes(error_dict)
        mock_request.return_value = self.response(response_body_bytes, status=404, reason='404')

        api = get.ApiForGet()
        with self.assertRaises(exceptions.ApiException) as cm:
            _response = api.get()

        exc: exceptions.ApiException[get.response_404.ApiResponse] = cm.exception
        expected_status = 404
        expected_reason = '404'
        self.assertEqual(exc.status, expected_status)
        self.assertEqual(exc.reason, expected_reason)
        expected_headers = {'content-type': 'application/json'}
        assert exc.api_response is not None
        self.assertEqual(exc.api_response.response.status, expected_status)
        self.assertEqual(exc.api_response.response.reason, expected_reason)
        self.assertEqual(exc.api_response.response.data, response_body_bytes)
        self.assertEqual(exc.api_response.response.headers, expected_headers)
        assert isinstance(exc.api_response.body, schemas.immutabledict)
        self.assertEqual(exc.api_response.body, error_dict)

        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake',
            body=None,
            method='GET',
            content_type=None,
            accept_content_type='application/json',
        )


if __name__ == '__main__':
    unittest.main()
