# coding: utf-8

"""


    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest
from unittest.mock import patch

import urllib3

from petstore_api.paths.fake.delete import operation as delete
from petstore_api import schemas, api_client
from petstore_api.configurations import api_configuration

from ... import ApiTestMixin


class TestFake(ApiTestMixin, unittest.TestCase):
    security_scheme_info = api_configuration.SecuritySchemeInfo(
        bearer_test=api_configuration.security_scheme_bearer_test.BearerTest(
            access_token='someAccessToken'
        )
    )
    used_configuration = api_configuration.ApiConfiguration(security_scheme_info=security_scheme_info)
    used_api_client = api_client.ApiClient(
        configuration=used_configuration
    )
    api = delete.ApiForDelete(api_client=used_api_client)

    @patch.object(urllib3.PoolManager, 'request')
    def test_delete_uses_http_bearer_auth(self, mock_request):
        mock_request.return_value = self.response(b'')

        query_params = {
            'required_string_group': 'a',
            'required_int64_group': 1,
        }
        header_params = {
            'required_boolean_group': 'true'
        }
        api_response = self.api.delete(query_params=query_params, header_params=header_params)
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake?required_string_group=a&required_int64_group=1',
            body=None,
            method='DELETE',
            content_type=None,
            accept_content_type=None,
            headers={
                'Authorization': 'Bearer someAccessToken',
                'required_boolean_group': 'true'
            }
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200


if __name__ == '__main__':
    unittest.main()
