# coding: utf-8

"""
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest
from unittest.mock import patch

import urllib3
import typing_extensions

import petstore_api
from petstore_api.paths.fake_pem_content_type.get import operation as get  # noqa: E501
from petstore_api import schemas, api_client
from petstore_api.configurations import api_configuration, schema_configuration

from ... import ApiTestMixin


class TestGet(ApiTestMixin, unittest.TestCase):
    # Get unit test stubs
    # route with tx and rx pem content type  # noqa: E501
    api_config = api_configuration.ApiConfiguration()
    schema_config = schema_configuration.SchemaConfiguration()
    used_api_client = api_client.ApiClient(configuration=api_config, schema_configuration=schema_config)
    api = get.ApiForGet(api_client=used_api_client)  # noqa: E501

    @patch.object(urllib3.PoolManager, 'request')
    def test_get_tx_and_r(self, mock_request):
        mock_request.return_value = self.response(b'receivedPemBlah', content_type="application/x-pem-file")

        api_response = self.api.get(body='sentPemBlah')
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://petstore.swagger.io:80/v2/fake/pemContentType',
            body=b'sentPemBlah',
            method='GET',
            content_type="application/x-pem-file",
            accept_content_type="application/x-pem-file",
        )

        assert api_response.response.status == 200
        assert api_response.body == 'receivedPemBlah'
        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.headers, schemas.Unset)

if __name__ == '__main__':
    unittest.main()
