# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import decimal
import unittest

from petstore_api.components.schema import no_additional_properties
from petstore_api import schemas, exceptions

class TestNoAdditionalProperties(unittest.TestCase):
    """NoAdditionalProperties unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testNoAdditionalProperties(self):
        """Test NoAdditionalProperties"""

        # works with only required
        arg: no_additional_properties.NoAdditionalPropertiesDictInput = {
            'id': 1
        }
        inst = no_additional_properties.NoAdditionalProperties.validate(arg)
        id_by_items = inst["id"]
        assert id_by_items == 1
        assert isinstance(id_by_items, int)
        id_by_property = inst.id
        assert id_by_property == 1
        assert isinstance(id_by_property, int)
        with self.assertRaises(KeyError):
            inst["petId"]
        assert inst.get("petId", schemas.unset) is schemas.unset
        assert inst.petId is schemas.unset

        # works with required + optional
        arg: no_additional_properties.NoAdditionalPropertiesDictInput = {
            'petId': 2,
            'id': 1
        }
        inst = no_additional_properties.NoAdditionalProperties.validate(arg)

        # needs required
        # TODO cast this to ApiTypeError?
        with self.assertRaisesRegex(
            TypeError,
            r"missing 1 required argument: \['id'\]"
        ):
            no_additional_properties.NoAdditionalProperties.validate({'petId': 2})

        # may not be passed additional properties
        # TODO cast this to ApiTypeError?
        with self.assertRaisesRegex(
            exceptions.ApiValueError,
            r"Value is invalid because it is disallowed by AnyTypeSchema"
        ):
            no_additional_properties.NoAdditionalProperties.validate({'id': 2, 'invalidArg': 1})

        # plural example
        # TODO cast this to ApiTypeError?
        with self.assertRaisesRegex(
            exceptions.ApiValueError,
            r"Value is invalid because it is disallowed by AnyTypeSchema"
        ):
            no_additional_properties.NoAdditionalProperties.validate({'id': 2, 'firstInvalidArg': 1, 'secondInvalidArg': 3})


if __name__ == '__main__':
    unittest.main()
