# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

from petstore_api import schemas
from petstore_api import api_client


class TestJSONEncoder(unittest.TestCase):
    """Fruit unit test stubs"""
    serializer = api_client.JSONEncoder()

    def test_receive_encode_str_types(self):
        schema_to_value = {
            schemas.StrSchema: 'hi',
            schemas.DateSchema: '2021-05-09',
            schemas.DateTimeSchema: '2020-01-01T00:00:00'
        }
        for schema, value in schema_to_value.items():
            inst = schema.validate(value)
            assert value == self.serializer.default(inst)

    def test_receive_encode_numeric_types(self):
        value_to_schema = (
            (1, schemas.IntSchema),
            (1.0, schemas.Float32Schema),
            (3.14, schemas.Float32Schema),
            (4, schemas.NumberSchema),
            (4.0, schemas.NumberSchema),
            (7.14, schemas.NumberSchema),
        )
        for value, schema in value_to_schema:
            inst = schema.validate(value)
            pre_serialize_value = self.serializer.default(inst)
            assert value == pre_serialize_value and type(value) == type(pre_serialize_value)


if __name__ == '__main__':
    unittest.main()
