# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import petstore_api
from petstore_api.components.schema import apple
from petstore_api.components.schema import banana
from petstore_api.components.schema import fruit
from petstore_api import schemas


class TestFruit(unittest.TestCase):
    """Fruit unit test stubs"""

    def testFruit(self):
        """Test Fruit"""

        # make an instance of Fruit, a composed schema oneOf model
        # banana test
        length_cm = 20.3
        color = 'yellow'
        inst = fruit.Fruit.validate({'lengthCm': length_cm, 'color': color})
        # check its properties
        self.assertEqual(inst['lengthCm'], length_cm)
        self.assertEqual(inst.get('lengthCm'), length_cm)
        self.assertEqual(inst['color'], color)
        self.assertEqual(inst.get('color'), color)

        # check the dict representation
        self.assertEqual(
            inst,
            {
                'lengthCm': length_cm,
                'color': color
            }
        )
        # setting values after instance creation is not allowed
        with self.assertRaises(TypeError):
            inst['color'] = 'some value'

        # getting a value that doesn't exist raises an exception
        # with a key
        with self.assertRaises(KeyError):
            assert inst['cultivar']
        assert inst.get('cultivar', schemas.unset) is schemas.unset

        """
        including extra parameters does not raise an exception
        because objects support additional properties by default
        """
        kwargs = dict(
            color=color,
            lengthCm=length_cm,
            additional_string='some value',
            additional_date='2021-01-02',
        )

        inst = fruit.Fruit.validate(kwargs)
        self.assertEqual(
            inst,
            kwargs
        )

        inst = fruit.Fruit.validate(kwargs)
        self.assertEqual(
            inst,
            kwargs
        )

        # including input parameters for two oneOf instances raise an exception
        with self.assertRaises(petstore_api.ApiValueError):
            fruit.Fruit.validate({
                'lengthCm': length_cm,
                'cultivar': 'granny smith'
            })

        # make an instance of Fruit, a composed schema oneOf model
        # apple test
        color = 'red'
        cultivar = 'golden delicious'
        inst = fruit.Fruit.validate({'color': color, 'cultivar': cultivar})
        # check its properties
        self.assertEqual(inst['color'], color)
        self.assertEqual(inst['cultivar'], cultivar)
        # check the dict representation
        self.assertEqual(
            inst,
            {
                'color': color,
                'cultivar': cultivar
            }
        )

    def testFruitNullValue(self):
        # Since 'apple' is nullable, validate we can create an apple with the 'null' value.
        inst = apple.Apple.validate(None)
        assert isinstance(inst, schemas.none_type_)
        assert inst is None

        # 'banana' is not nullable.
        # TODO cast this into ApiTypeError?
        with self.assertRaises(TypeError):
            banana.Banana.validate(None)

        # Since 'fruit' has oneOf 'apple', 'banana' and 'apple' is nullable,
        # validate we can create a fruit with the 'null' value.
        inst = fruit.Fruit.validate(None)
        assert isinstance(inst, schemas.none_type_)
        assert inst is None


if __name__ == '__main__':
    unittest.main()
