# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""


import unittest
from unittest import mock

import petstore_api
from petstore_api import schemas
from petstore_api.schemas import none_type_
from petstore_api.components.schema import shape
from petstore_api.components.schema import drawing


class TestDrawing(unittest.TestCase):
    """Drawing unit test stubs"""

    def test_create_instances(self):
        """
        Validate instance can be created
        """

        inst = shape.Shape.validate({
            'shapeType': "Triangle",
            'triangleType': "IsoscelesTriangle"
        })
        assert isinstance(inst, schemas.immutabledict)

    @mock.patch('petstore_api.components.schema.drawing.typing.cast')
    def test_shapes_casting(self, mock_cast):
        def side_effect(cls, value):
            return value
        mock_cast.side_effect = side_effect
        one_shape = shape.Shape.validate({
            'shapeType': "Triangle",
            'triangleType': "EquilateralTriangle"
        })
        inst = drawing.Drawing.validate({
            'shapes': [
                one_shape,
            ],
        })
        inst.shapes
        assert mock_cast.mock_calls[-1] == mock.call(
            drawing.ShapesTuple,
            (
                one_shape,
            ),
        )

    def test_deserialize_oneof_reference(self):
        """
        Validate the scenario when the type of a OAS property is 'oneOf', and the 'oneOf'
        schema is specified as a reference ($ref), not an inline 'oneOf' schema.
        """
        isosceles_triangle = shape.Shape.validate({
            'shapeType': "Triangle",
            'triangleType': "IsoscelesTriangle"
        })
        assert isinstance(isosceles_triangle, schemas.immutabledict)

        inst = drawing.Drawing.validate({
            'mainShape': isosceles_triangle,
            'shapes': [
                shape.Shape.validate({
                    'shapeType': "Triangle",
                    'triangleType': "EquilateralTriangle"
                }),
                shape.Shape.validate({
                    'shapeType': "Triangle",
                    'triangleType': "IsoscelesTriangle"
                }),
                shape.Shape.validate({
                    'shapeType': "Triangle",
                    'triangleType': "EquilateralTriangle"
                }),
                shape.Shape.validate({
                    'shapeType': "Quadrilateral",
                    'quadrilateralType': "ComplexQuadrilateral"
                })
            ],
        })
        assert isinstance(inst, drawing.DrawingDict)
        assert isinstance(inst["mainShape"], schemas.immutabledict)
        self.assertEqual(len(inst["shapes"]), 4)
        assert isinstance(inst["shapes"][0], schemas.immutabledict)
        assert isinstance(inst["shapes"][1], schemas.immutabledict)
        assert isinstance(inst["shapes"][2], schemas.immutabledict)
        assert isinstance(inst["shapes"][3], schemas.immutabledict)

        # Validate we cannot assign the None value to mainShape because the 'null' type
        # is not one of the allowed types in the 'Shape' schema.
        err_msg = (r"Invalid inputs given to generate an instance of .+?Shape.+? "
                   r"None of the oneOf schemas matched the input data.")
        with self.assertRaisesRegex(
                petstore_api.ApiValueError,
                err_msg
        ):
            drawing.Drawing.validate({
                # 'mainShape' has type 'Shape', which is a oneOf [triangle, quadrilateral]
                # So the None value should not be allowed and an exception should be raised.
                'mainShape': None,
            })

        """
        We can pass in a Triangle instance in shapes
        Under the hood it is converted into a dict, and that dict payload
        does validate as a Shape, so this works
        """
        from petstore_api.components.schema.triangle import Triangle
        inst = drawing.Drawing.validate({
            'mainShape': isosceles_triangle,
            'shapes': [
                Triangle.validate({
                    'shapeType': "Triangle",
                    'triangleType': "EquilateralTriangle"
                })
            ]
        })
        self.assertEqual(len(inst["shapes"]), 1)
        shapes = inst["shapes"]
        assert isinstance(shapes[0], schemas.immutabledict)

    def test_deserialize_oneof_reference_with_null_type(self):
        """
        Validate the scenario when the type of a OAS property is 'oneOf', and the 'oneOf'
        schema is specified as a reference ($ref), not an inline 'oneOf' schema.
        Further, the 'oneOf' schema has a 'null' type child schema (as introduced in
        OpenAPI 3.1).
        """

        # Validate we can assign the None value to shape_or_null, because the 'null' type
        # is one of the allowed types in the 'ShapeOrNull' schema.
        inst = drawing.Drawing.validate({
            # 'shapeOrNull' has type 'ShapeOrNull', which is a oneOf [null, triangle, quadrilateral]
            'shapeOrNull': None,
        })
        assert isinstance(inst, drawing.DrawingDict)
        self.assertFalse('mainShape' in inst)
        self.assertTrue('shapeOrNull' in inst)
        self.assertTrue(isinstance(inst["shapeOrNull"], none_type_))

    def test_deserialize_oneof_reference_with_nullable_type(self):
        """
        Validate the scenario when the type of a OAS property is 'oneOf', and the 'oneOf'
        schema is specified as a reference ($ref), not an inline 'oneOf' schema.
        Further, the 'oneOf' schema has the 'nullable' attribute (as introduced in
        OpenAPI 3.0 and deprecated in 3.1).
        """

        # Validate we can assign the None value to nullableShape, because the NullableShape
        # has the 'nullable: true' attribute.
        inst = drawing.Drawing.validate({
            # 'nullableShape' has type 'NullableShape', which is a oneOf [triangle, quadrilateral]
            # and the 'nullable: true' attribute.
            'nullableShape': None,
        })
        assert isinstance(inst, drawing.DrawingDict)
        self.assertFalse('mainShape' in inst)
        self.assertTrue('nullableShape' in inst)
        self.assertTrue(isinstance(inst["nullableShape"], none_type_))


if __name__ == '__main__':
    unittest.main()
