# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import decimal
import unittest

import petstore_api
from petstore_api import schemas
from petstore_api.components.schema.decimal_payload import DecimalPayload


class TestDecimalPayload(unittest.TestCase):
    """DecimalPayload unit test stubs"""

    def test_DecimalPayload(self):
        """Test DecimalPayload"""

        m = DecimalPayload.validate('12')
        assert isinstance(m, str)
        assert m == '12'
        assert schemas.as_decimal(m) == decimal.Decimal('12')

        m = DecimalPayload.validate('12.34')
        assert isinstance(m, str)
        assert m == '12.34'
        assert schemas.as_decimal(m) == decimal.Decimal('12.34')

        # passing in a Decimal does not work
        with self.assertRaises(petstore_api.ApiTypeError):
            DecimalPayload.validate(decimal.Decimal('12.34'))


if __name__ == '__main__':
    unittest.main()
