# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""


import unittest

import petstore_api
from petstore_api import schemas
from petstore_api.components.schema.date_with_validations import DateWithValidations
from datetime import date, datetime


class TestDateWithValidations(unittest.TestCase):
    """DateWithValidations unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testDateWithValidations(self):
        """Test DateWithValidations"""

        # client side date inputs
        valid_values = [date(2020, 1, 1), '2020-01-01']
        expected_date = '2020-01-01'
        for valid_value in valid_values:
            inst = DateWithValidations.validate(valid_value)
            assert inst == expected_date

        # various formats work
        valid_values = ["2020-01-01", "2020-01", "2020"]
        expected_date = date(2020, 1, 1)
        for valid_value in valid_values:
            inst = DateWithValidations.validate(valid_value)
            assert schemas.as_date(inst) == expected_date

        # value error is raised if an invalid string is passed in
        with self.assertRaisesRegex(
            petstore_api.ApiValueError,
            r"Value does not conform to the required ISO-8601 date format. Invalid value '2020-01-01T00:00:00Z' for type date at \('args\[0\]',\)"
        ):
            DateWithValidations.validate("2020-01-01T00:00:00Z")

        # value error is raised if a datetime is passed in
        with self.assertRaisesRegex(
            petstore_api.ApiValueError,
            r"Value does not conform to the required ISO-8601 date format. Invalid value '2020-01-01T00:00:00' for type date at \('args\[0\]',\)"
        ):
            DateWithValidations.validate(datetime(2020, 1, 1))

        # value error is raised if an invalid string is passed in
        with self.assertRaisesRegex(
                petstore_api.ApiValueError,
                r"Value does not conform to the required ISO-8601 date format. Invalid value 'abcd' for type date at \('args\[0\]',\)"
        ):
            DateWithValidations.validate("abcd")

        # pattern checking for str input
        error_regex = r"Invalid value `2019-01-01`, must match regular expression `.+?` at \('args\[0\]',\)"
        with self.assertRaisesRegex(
            petstore_api.ApiValueError,
            error_regex
        ):
            DateWithValidations.validate("2019-01-01")
        # pattern checking for date input
        with self.assertRaisesRegex(
            petstore_api.ApiValueError,
            error_regex
        ):
            DateWithValidations.validate(date(2019, 1, 1))


if __name__ == '__main__':
    unittest.main()
