# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""


import unittest

from petstore_api import exceptions
from petstore_api.components.schema import array_with_validations_in_items


class TestArrayWithValidationsInItems(unittest.TestCase):
    """ArrayWithValidationsInItems unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testArrayWithValidationsInItems(self):
        """Test ArrayWithValidationsInItems"""

        valid_values = (-1, 5, 7)
        for valid_value in valid_values:
            inst = array_with_validations_in_items.ArrayWithValidationsInItems.validate([valid_value])
            assert isinstance(inst, array_with_validations_in_items.ArrayWithValidationsInItemsTuple)
            assert inst == (valid_value,)

        with self.assertRaisesRegex(
            exceptions.ApiValueError,
            r"Invalid value `8`, must be a value less than or equal to `7` at \('args\[0\]', 0\)"
        ):
            array_with_validations_in_items.ArrayWithValidationsInItems.validate([8])

        with self.assertRaisesRegex(
            exceptions.ApiValueError,
            r"Invalid value `\(1, 2, 3\)`, number of items must be less than or equal to `2` at \('args\[0\]',\)"
        ):
            array_with_validations_in_items.ArrayWithValidationsInItems.validate([1, 2, 3])


if __name__ == '__main__':
    unittest.main()
