
"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""


import dataclasses
from decimal import Decimal
import typing
import unittest

import petstore_api
from petstore_api import schemas
from petstore_api.schemas import (
    AnyTypeSchema,
    DictSchema,
    ListSchema,
    StrSchema,
    NumberSchema,
    IntSchema,
    BoolSchema,
    NoneSchema,
    DateSchema,
    DateTimeSchema,
    DecimalSchema,
)


class TestAnyTypeSchema(unittest.TestCase):

    def testDictSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):            
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                DictSchema,
            )

        m = Model.validate({'a': 1, 'b': 'hi'})
        assert isinstance(m, schemas.immutabledict)
        assert m == schemas.immutabledict({'a': 1, 'b': 'hi'})

    def testListSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                ListSchema,
            )

        m = Model.validate([1, 'hi'])
        assert isinstance(m, tuple)
        assert m == tuple([1, 'hi'])

    def testStrSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                StrSchema,
            )

        m = Model.validate('hi')
        assert isinstance(m, str)
        assert m == 'hi'

    def testNumberSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                NumberSchema,
            )

        m = Model.validate(1)
        assert isinstance(m, int)
        assert m == 1

        m = Model.validate(3.14)
        assert isinstance(m, float)
        assert m == Decimal(3.14)

    def testIntSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                IntSchema,
            )

        m = Model.validate(1)
        assert isinstance(m, int)
        assert m == 1

        with self.assertRaises(petstore_api.ApiValueError):
            # can't pass in float into Int
            Model.validate(3.14)

    def testBoolSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                BoolSchema,
            )

        m = Model.validate(True)
        assert isinstance(m, bool)
        self.assertTrue(m)
        assert m is True

        m = Model.validate(False)
        assert isinstance(m, bool)
        self.assertFalse(m)
        assert m is False

    def testNoneSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                NoneSchema,
            )

        m = Model.validate(None)
        assert m is None

    def testDateSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                DateSchema,
            )

        m = Model.validate('1970-01-01')
        assert isinstance(m, str)
        assert m == '1970-01-01'

    def testDateTimeSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                DateTimeSchema,
            )

        m = Model.validate('2020-01-01T00:00:00')
        assert isinstance(m, str)
        assert m == '2020-01-01T00:00:00'

    def testDecimalSchema(self):
        @dataclasses.dataclass(frozen=True)
        class Model(AnyTypeSchema):
            all_of: typing.Tuple[typing.Type[schemas.Schema], ...] = (
                AnyTypeSchema,
                DecimalSchema,
            )

        m = Model.validate('12.34')
        assert m == '12.34'
        assert isinstance(m, str)
        assert schemas.as_decimal(m) == Decimal('12.34')


if __name__ == '__main__':
    unittest.main()
