# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import datetime
import decimal
import unittest
import uuid

from petstore_api.components.schema.any_type_and_format import AnyTypeAndFormat
from petstore_api import exceptions


class TestAnyTypeAndFormat(unittest.TestCase):
    """AnyTypeAndFormat unit test stubs"""

    def test_uuid(self):
        valid_uuid_str = '12345678-1234-5678-1234-567812345678'
        valid_values = (
            valid_uuid_str,
            {},
            uuid.UUID(valid_uuid_str),
            1,
            3.14,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'uuid': valid_value})

        # an invalid value does not work
        with self.assertRaises(exceptions.ApiValueError):
            AnyTypeAndFormat.validate({'uuid': '1'})

    def test_date(self):
        valid_values = (
            '2022-01-02',
            {},
            datetime.date(2022, 1, 2),
            1,
            3.14,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'date': valid_value})

        # an invalid value does not work
        with self.assertRaises(exceptions.ApiValueError):
            AnyTypeAndFormat.validate({'date': '1'})

    def test_date_time(self):
        valid_values = (
            "2020-01-01T00:00:00",
            {},
            datetime.datetime(2020, 1, 1),
            1,
            3.14,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'date-time': valid_value})

        # an invalid value does not work
        with self.assertRaises(exceptions.ApiValueError):
            AnyTypeAndFormat.validate({'date-time': 'abcd'})

    def test_number(self):
        valid_values = (
            '3.14',
            {},
            1,
            3.14,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'number': valid_value})

        # an invalid value does not work
        with self.assertRaises(exceptions.ApiValueError):
            AnyTypeAndFormat.validate({'number': 'a'})

    def test_int32(self):
        min_bound = -2147483648
        max_bound = 2147483647
        under_min_number = min_bound - 1
        over_max_number = max_bound + 1
        valid_values = (
            'a',
            {},
            1,
            min_bound,
            max_bound,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'int32': valid_value})

        # invalid values do not work
        invalid_values = (
            min_bound - 1,
            max_bound + 1,
            3.14,
            under_min_number,
            over_max_number,
        )
        for invalid_value in invalid_values:
            with self.assertRaises(exceptions.ApiValueError):
                AnyTypeAndFormat.validate({'int32': invalid_value})

    def test_int64(self):
        min_bound = -9223372036854775808
        max_bound = 9223372036854775807
        under_min_number = min_bound - 1
        over_max_number = max_bound + 1
        valid_values = (
            'a',
            {},
            1,
            min_bound,
            max_bound,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'int64': valid_value})

        # invalid values do not work
        invalid_values = (
            min_bound - 1,
            max_bound + 1,
            under_min_number,
            over_max_number,
            3.14,
        )
        for invalid_value in invalid_values:
            with self.assertRaises(exceptions.ApiValueError):
                AnyTypeAndFormat.validate({'int64': invalid_value})

    def test_float(self):
        min_bound = -3.4028234663852886e+38
        max_bound = 3.4028234663852886e+38
        valid_values = (
            'a',
            {},
            1,
            3.14,
            min_bound,
            max_bound,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'double': valid_value})

        # invalid values do not work
        invalid_values = (
            3.402823466385289e+38, # used math.nextafter to find this value
            -3.402823466385289e+38, # used math.nextafter to find this value
        )
        for invalid_value in invalid_values:
            with self.assertRaises(exceptions.ApiValueError):
                AnyTypeAndFormat.validate({'float': invalid_value})

    def test_double(self):
        min_bound = -1.7976931348623157E+308
        max_bound = 1.7976931348623157E+308
        valid_values = (
            'a',
            {},
            1,
            3.14,
            min_bound,
            max_bound,
            True,
            None,
            [],
            (),
            b'abc'
        )
        for valid_value in valid_values:
            AnyTypeAndFormat.validate({'double': valid_value})

        """
        This only works if stored values use decimal.Decimal
        float maxes out at 64 bit value so storing values greater than that is not possible
        with decimal.localcontext() as ctx:
            ctx.prec = 310
            # local higher precision context needed to correctly create these numbers
            invalid_values = (
                min_bound - 0.1,
                max_bound + 0.1,
                min_bound - 1,
                max_bound + 1
            )
        # invalid values do not work
        for invalid_value in invalid_values:
            with self.assertRaises(exceptions.ApiValueError):
                AnyTypeAndFormat.validate({'double': invalid_value})
        """


if __name__ == '__main__':
    unittest.main()
