# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""


import unittest
from unittest import mock

import petstore_api
from petstore_api.components.schema import animal


class TestAnimal(unittest.TestCase):
    """Animal unit test stubs"""

    def testAnimal(self):
        """Test Animal"""

        regex_err = (
            r"Invalid discriminator value was passed in to Animal.className "
            r"Only the values \['Cat', 'Dog'\] are allowed at \('args\[0\]', 'className'\)"
        )
        with self.assertRaisesRegex(petstore_api.ApiValueError, regex_err):
            animal.Animal.validate({'className': 'Fox', 'color': 'red'})

        inst = animal.Animal.validate({'className': 'Cat', 'color': 'black'})
        assert isinstance(inst, animal.AnimalDict)
        assert set(inst.keys()) == {'className', 'color'}
        assert inst.className == 'Cat'
        assert inst["color"] == 'black'
        assert isinstance(inst["color"], str)
        assert isinstance(inst.className, str)

        # pass in optional param
        inst = animal.Animal.validate({'className': 'Cat', 'color': 'black', 'declawed': True})
        assert isinstance(inst, animal.AnimalDict)
        assert set(inst.keys()) == {'className', 'color', 'declawed'}
        assert inst.className == 'Cat'
        assert inst["color"] == 'black'
        assert inst["declawed"] is True
        assert isinstance(inst["color"], str)
        assert isinstance(inst.className, str)
        assert isinstance(inst["declawed"], bool)

        # make a Dog
        inst = animal.Animal.validate({'className': 'Dog', 'color': 'black'})
        assert isinstance(inst, animal.AnimalDict)
        assert set(inst.keys()) == {'className', 'color'}
        assert inst.className == 'Dog'
        assert inst["color"] == 'black'
        assert isinstance(inst["color"], str)
        assert isinstance(inst.className, str)

        # pass in optional param
        inst = animal.Animal.validate({'className': 'Dog', 'color': 'black', 'breed':'Labrador'})
        assert isinstance(inst, animal.AnimalDict)
        assert set(inst.keys()) == {'className', 'color', 'breed'}
        assert inst.className == 'Dog'
        assert inst.color == 'black'
        assert inst["color"] == 'black'
        assert inst["breed"] == 'Labrador'
        assert isinstance(inst.className, str)
        assert isinstance(inst["color"], str)
        assert isinstance(inst["breed"], str)

    def test_animal_color_is_cast(self):
        inst = animal.Animal.validate({'className': 'Dog', 'color': 'black'})
        def mock_typing_cast(cls, val):
            return val
        with mock.patch('petstore_api.components.schema.animal.typing.cast') as mock_cast:
            mock_cast.side_effect = mock_typing_cast
            assert inst.color == 'black'
            mock_cast.assert_called_with(str, 'black')


if __name__ == '__main__':
    unittest.main()
