# coding: utf-8

"""
    OpenAPI Petstore
    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from petstore_api.shared_imports.response_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

from .content.application_xml import schema as application_xml_schema
from .content.application_json import schema as application_json_schema
from .headers import header_x_rate_limit
from .headers import header_int32
from .headers import header_x_expires_after
from .headers import header_ref_content_schema_header
from .headers import header_number_header
from . import header_parameters
parameters: typing.Dict[str, typing.Type[api_client.HeaderParameterWithoutName]] = {
    'X-Rate-Limit': header_x_rate_limit.XRateLimit,
    'int32': header_int32.Int32,
    'X-Expires-After': header_x_expires_after.XExpiresAfter,
    'ref-content-schema-header': header_ref_content_schema_header.RefContentSchemaHeader,
    'numberHeader': header_number_header.NumberHeader,
}


@dataclasses.dataclass(frozen=True)
class ApiResponse(api_response.ApiResponse):
    body: typing.Union[
        str,
        str,
    ]
    headers: header_parameters.HeadersDict


class ResponseFor200(api_client.OpenApiResponse[ApiResponse]):
    @classmethod
    def get_response(cls, response, headers, body) -> ApiResponse:
        return ApiResponse(response=response, body=body, headers=headers)


    class ApplicationXmlMediaType(api_client.MediaType):
        schema: typing_extensions.TypeAlias = application_xml_schema.Schema


    class ApplicationJsonMediaType(api_client.MediaType):
        schema: typing_extensions.TypeAlias = application_json_schema.Schema
    content = {
        'application/xml': ApplicationXmlMediaType,
        'application/json': ApplicationJsonMediaType,
    }
    headers=parameters
    headers_schema = header_parameters.Headers
