# coding: utf-8

"""
    OpenAPI Petstore
    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from petstore_api import api_client
from petstore_api.shared_imports.operation_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

from .. import path
from .responses import (
    response_303,
    response_3xx,
)


__StatusCodeToResponse = typing.TypedDict(
    '__StatusCodeToResponse',
    {
        '303': typing.Type[response_303.ResponseFor303],
    }
)
_status_code_to_response: __StatusCodeToResponse = {
    '303': response_303.ResponseFor303,
}
__RangedStatusCodeToResponse = typing.TypedDict(
    '__RangedStatusCodeToResponse',
    {
        '3': typing.Type[response_3xx.ResponseFor3XX],
    }
)
_ranged_status_code_to_response: __RangedStatusCodeToResponse = {
    '3': response_3xx.ResponseFor3XX,
}
_non_error_status_codes = frozenset({
    '303',
})
_non_error_ranged_status_codes = frozenset({
    '3',
})


class BaseApi(api_client.Api):
    @typing.overload
    def _redirection(
        self,
        *,
        skip_deserialization: typing.Literal[False] = False,
        server_index: typing.Optional[int] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, float, typing.Tuple]] = None,
    ) -> typing.Union[
        response_3xx.ApiResponse,
        response_303.ApiResponse,
    ]: ...

    @typing.overload
    def _redirection(
        self,
        *,
        skip_deserialization: typing.Literal[True],
        server_index: typing.Optional[int] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, float, typing.Tuple]] = None,
    ) -> api_response.ApiResponseWithoutDeserialization: ...

    def _redirection(
        self,
        *,
        skip_deserialization: bool = False,
        server_index: typing.Optional[int] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, float, typing.Tuple]] = None,
    ):
        """
        operation with redirection responses
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        used_path = path
        # TODO add cookie handling
        host = self.api_client.configuration.get_server_url(
            "servers", server_index
        )

        raw_response = self.api_client.call_api(
            resource_path=used_path,
            method='get',
            host=host,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            skip_deser_response = api_response.ApiResponseWithoutDeserialization(response=raw_response)
            self._verify_response_status(skip_deser_response)
            return skip_deser_response

        status = str(raw_response.status)
        if status in _non_error_status_codes:
            status_code = typing.cast(
                typing.Literal[
                    '303',
                ],
                status
            )
            return _status_code_to_response[status_code].deserialize(
                raw_response, self.api_client.schema_configuration)

        ranged_response_status_code = str(raw_response.status)[0]
        if ranged_response_status_code in _non_error_ranged_status_codes:
            ranged_status_code = typing.cast(
                typing.Literal[
                    '3',
                ],
                ranged_response_status_code
            )
            return _ranged_status_code_to_response[ranged_status_code].deserialize(
                raw_response, self.api_client.schema_configuration)

        response = api_response.ApiResponseWithoutDeserialization(response=raw_response)
        self._verify_response_status(response)
        return response


class Redirection(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId.snakeCase fn names
    redirection = BaseApi._redirection


class ApiForGet(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names
    get = BaseApi._redirection
