# coding: utf-8

"""
    OpenAPI Petstore
    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from petstore_api.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

Width: typing_extensions.TypeAlias = schemas.DecimalSchema

from petstore_api.components.schema import decimal_payload
from petstore_api.components.schema import money
Properties = typing.TypedDict(
    'Properties',
    {
        "length": typing.Type[decimal_payload.DecimalPayload],
        "width": typing.Type[Width],
        "cost": typing.Type[money.Money],
    }
)


class ObjectWithDecimalPropertiesDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "length",
        "width",
        "cost",
    })
    
    def __new__(
        cls,
        *,
        length: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        width: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        cost: typing.Union[
            money.MoneyDictInput,
            money.MoneyDict,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("length", length),
            ("width", width),
            ("cost", cost),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(ObjectWithDecimalPropertiesDictInput, arg_)
        return ObjectWithDecimalProperties.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            ObjectWithDecimalPropertiesDictInput,
            ObjectWithDecimalPropertiesDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ObjectWithDecimalPropertiesDict:
        return ObjectWithDecimalProperties.validate(arg, configuration=configuration)
    
    @property
    def length(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("length", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def width(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("width", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def cost(self) -> typing.Union[money.MoneyDict, schemas.Unset]:
        val = self.get("cost", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            money.MoneyDict,
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
ObjectWithDecimalPropertiesDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class ObjectWithDecimalProperties(
    schemas.Schema[ObjectWithDecimalPropertiesDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: ObjectWithDecimalPropertiesDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            ObjectWithDecimalPropertiesDictInput,
            ObjectWithDecimalPropertiesDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ObjectWithDecimalPropertiesDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

