# coding: utf-8

"""
    OpenAPI Petstore
    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from petstore_api.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

AdditionalProperties: typing_extensions.TypeAlias = schemas.NotAnyTypeSchema
Status: typing_extensions.TypeAlias = schemas.Int32Schema
Message: typing_extensions.TypeAlias = schemas.StrSchema
MultiPropertiesSchemaRequiredDictInput = typing.TypedDict(
    'MultiPropertiesSchemaRequiredDictInput',
    {
        "status": int,
    }
)

from petstore_api.components.schema import items_schema


class DataTuple(
    typing.Tuple[
        items_schema.ItemsSchemaDict,
        ...
    ]
):

    def __new__(cls, arg: typing.Union[DataTupleInput, DataTuple], configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None):
        return Data.validate(arg, configuration=configuration)
DataTupleInput = typing.Union[
    typing.List[
        typing.Union[
            items_schema.ItemsSchemaDictInput,
            items_schema.ItemsSchemaDict,
        ],
    ],
    typing.Tuple[
        typing.Union[
            items_schema.ItemsSchemaDictInput,
            items_schema.ItemsSchemaDict,
        ],
        ...
    ]
]


@dataclasses.dataclass(frozen=True)
class Data(
    schemas.Schema[schemas.immutabledict, DataTuple]
):
    types: typing.FrozenSet[typing.Type] = frozenset({tuple})
    items: typing.Type[items_schema.ItemsSchema] = dataclasses.field(default_factory=lambda: items_schema.ItemsSchema) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            tuple: DataTuple
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            DataTupleInput,
            DataTuple,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> DataTuple:
        return super().validate_base(
            arg,
            configuration=configuration,
        )
Properties = typing.TypedDict(
    'Properties',
    {
        "status": typing.Type[Status],
        "data": typing.Type[Data],
        "message": typing.Type[Message],
    }
)
MultiPropertiesSchemaOptionalDictInput = typing.TypedDict(
    'MultiPropertiesSchemaOptionalDictInput',
    {
        "data": typing.Union[
            DataTupleInput,
            DataTuple
        ],
        "message": str,
    },
    total=False
)


class MultiPropertiesSchemaDict(schemas.immutabledict[str, typing.Union[
    str,
    typing.Tuple[schemas.OUTPUT_BASE_TYPES],
    int,
]]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "status",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "data",
        "message",
    })
    
    def __new__(
        cls,
        *,
        status: int,
        data: typing.Union[
            DataTupleInput,
            DataTuple,
            schemas.Unset
        ] = schemas.unset,
        message: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "status": status,
        }
        for key_, val in (
            ("data", data),
            ("message", message),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        used_arg_ = typing.cast(MultiPropertiesSchemaDictInput, arg_)
        return MultiPropertiesSchema.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            MultiPropertiesSchemaDictInput,
            MultiPropertiesSchemaDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> MultiPropertiesSchemaDict:
        return MultiPropertiesSchema.validate(arg, configuration=configuration)
    
    @property
    def status(self) -> int:
        return typing.cast(
            int,
            self.__getitem__("status")
        )
    
    @property
    def data(self) -> typing.Union[DataTuple, schemas.Unset]:
        val = self.get("data", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            DataTuple,
            val
        )
    
    @property
    def message(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("message", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )


class MultiPropertiesSchemaDictInput(MultiPropertiesSchemaRequiredDictInput, MultiPropertiesSchemaOptionalDictInput):
    pass


@dataclasses.dataclass(frozen=True)
class MultiPropertiesSchema(
    schemas.Schema[MultiPropertiesSchemaDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "status",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    additional_properties: typing.Type[AdditionalProperties] = dataclasses.field(default_factory=lambda: AdditionalProperties) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: MultiPropertiesSchemaDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            MultiPropertiesSchemaDictInput,
            MultiPropertiesSchemaDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> MultiPropertiesSchemaDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

