# coding: utf-8

"""
    OpenAPI Petstore
    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from petstore_api.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

AdditionalProperties: typing_extensions.TypeAlias = schemas.NotAnyTypeSchema
Path: typing_extensions.TypeAlias = schemas.StrSchema
Value: typing_extensions.TypeAlias = schemas.AnyTypeSchema


class OpEnums:

    @schemas.classproperty
    def ADD(cls) -> typing.Literal["add"]:
        return Op.validate("add")

    @schemas.classproperty
    def REPLACE(cls) -> typing.Literal["replace"]:
        return Op.validate("replace")

    @schemas.classproperty
    def TEST(cls) -> typing.Literal["test"]:
        return Op.validate("test")


@dataclasses.dataclass(frozen=True)
class Op(
    schemas.Schema
):
    types: typing.FrozenSet[typing.Type] = frozenset({
        str,
    })
    enum_value_to_name: typing.Mapping[typing.Union[int, float, str, schemas.Bool, None], str] = dataclasses.field(
        default_factory=lambda: {
            "add": "ADD",
            "replace": "REPLACE",
            "test": "TEST",
        }
    )
    enums = OpEnums

    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["add"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["add"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["replace"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["replace"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["test"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["test"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: str,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["add","replace","test",]: ...
    @classmethod
    def validate(
        cls,
        arg,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal[
        "add",
        "replace",
        "test",
    ]:
        validated_arg = super().validate_base(
            arg,
            configuration=configuration,
        )
        return typing.cast(typing.Literal[
                "add",
                "replace",
                "test",
            ],
            validated_arg
        )
Properties = typing.TypedDict(
    'Properties',
    {
        "path": typing.Type[Path],
        "value": typing.Type[Value],
        "op": typing.Type[Op],
    }
)


class JSONPatchRequestAddReplaceTestDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "op",
        "path",
        "value",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
    })
    
    def __new__(
        cls,
        *,
        op: typing.Literal[
            "add",
            "replace",
            "test"
        ],
        path: str,
        value: typing.Union[
            schemas.INPUT_TYPES_ALL,
            schemas.OUTPUT_BASE_TYPES
        ],
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "op": op,
            "path": path,
            "value": value,
        }
        used_arg_ = typing.cast(JSONPatchRequestAddReplaceTestDictInput, arg_)
        return JSONPatchRequestAddReplaceTest.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            JSONPatchRequestAddReplaceTestDictInput,
            JSONPatchRequestAddReplaceTestDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> JSONPatchRequestAddReplaceTestDict:
        return JSONPatchRequestAddReplaceTest.validate(arg, configuration=configuration)
    
    @property
    def op(self) -> typing.Literal["add", "replace", "test"]:
        return typing.cast(
            typing.Literal["add", "replace", "test"],
            self.__getitem__("op")
        )
    
    @property
    def path(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("path")
        )
    
    @property
    def value(self) -> schemas.OUTPUT_BASE_TYPES:
        return self.__getitem__("value")
JSONPatchRequestAddReplaceTestDictInput = typing.TypedDict(
    'JSONPatchRequestAddReplaceTestDictInput',
    {
        "op": typing.Literal[
            "add",
            "replace",
            "test"
        ],
        "path": str,
        "value": typing.Union[
            schemas.INPUT_TYPES_ALL,
            schemas.OUTPUT_BASE_TYPES
        ],
    }
)


@dataclasses.dataclass(frozen=True)
class JSONPatchRequestAddReplaceTest(
    schemas.Schema[JSONPatchRequestAddReplaceTestDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "op",
        "path",
        "value",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    additional_properties: typing.Type[AdditionalProperties] = dataclasses.field(default_factory=lambda: AdditionalProperties) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: JSONPatchRequestAddReplaceTestDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            JSONPatchRequestAddReplaceTestDictInput,
            JSONPatchRequestAddReplaceTestDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> JSONPatchRequestAddReplaceTestDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

