# petstore-api
This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.

This Python package is automatically generated by the [OpenAPI JSON Schema Generator](https://github.com/openapi-json-schema-tools/openapi-json-schema-generator) project:

- OpenAPI document version: 1.0.0
- Python Package version: 1.0.0
- OpenAPI JSON Schema Generator, Generator: PythonClientGenerator

## Requirements

Python &gt;&#x3D;3.8

## Migration Guides
- [3.0.0 Migration Guide](migration_3_0_0.md)
- [2.0.0 Migration Guide](migration_2_0_0.md)
- [Migration from Other Python Generators](migration_other_python_generators.md)


## Installation
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import petstore_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python -m pip install . --user
```
(or `python -m pip install .` to install the package for all users)

Then import the package:
```python
import petstore_api
```

## Usage Notes
### Validation, Immutability, and Data Type
This python code validates data to schema classes and return back an immutable instance containing the data
which subclasses all validated schema classes. This ensure that
- valid data cannot be mutated and become invalid to a set of schemas
  - the one exception is that files are not immutable, so schema instances storing/sending/receiving files are not immutable

Here is the mapping from json schema types to python subclassed types:
| Json Schema Type | Python Base Class |
| ---------------- | ----------------- |
| object           | schemas.immutabledict |
| array            | tuple |
| string           | str |
| number           | float, int |
| integer          | int |
| boolean          | bool |
| null             | None |
| AnyType (unset)  | typing.Union[schemas.immutabledict, tuple, str, float, int, bool, None] |

### Storage of Json Schema Definition in Python Classes
In openapi v3.0.3 there are ~ 28 json schema keywords. Almost all of them can apply if
type is unset. I have chosen to separate the storage of json schema definition info and output
validated classes for payload instantiation.

<details>
  <summary>Reason</summary>

This json schema data is stored in each class that is written for a schema, in a component or
other openapi document location. This class is only responsible for storing schema info.
Output classes like those that store dict payloads are written separately and are
returned by the Schema.validate method when that method is passed in dict input.
This prevents payload property access methods from
colliding with json schema definition.
</details>

### Json Schema Type Object
Most component schemas (models) are probably of type object. Which is a map data structure.
Json schema allows string keys in this map, which means schema properties can have key names that are
invalid python variable names. Names like:
- "hi-there"
- "1variable"
- "@now"
- " "
- "from"

To allow these use cases to work, schemas.immutabledict is used as the base class of type object schemas.
This means that one can use normal dict methods on instances of these classes.

<details>
  <summary>Other Details</summary>

- optional properties which were not set will not exist in the instance
- None is only allowed in as a value if type: "null" was included or nullable: true was set
- preserving the original key names is required to properly validate a payload to multiple json schemas
</details>

### Json Schema Type + Format, Validated Data Storage
N schemas can be validated on the same payload.
To allow multiple schemas to validate, the data must be stored using one base class whether or not
a json schema format constraint exists in the schema.
See the below accessors for string data:
- type string + format: See schemas.as_date, schemas.as_datetime, schemas.as_decimal, schemas.as_uuid

In json schema, type: number with no format validates both integers and floats,
so int and float values are stored for type number.

<details>
  <summary>String + Date Example</summary>

For example the string payload '2023-12-20' is validates to both of these schemas:
1. string only
```
- type: string
```
2. string and date format
```
- type: string
  format: date
```
Because of use cases like this, a datetime.date is allowed as an input to this schema, but the data
is stored as a string.
</details>

## Getting Started

Please follow the [installation procedure](#installation) and then run the following:

```python
import petstore_api
from petstore_api.configurations import api_configuration
from petstore_api.apis.tags import fake_api
from pprint import pprint
used_configuration = api_configuration.ApiConfiguration(
)
# Enter a context with an instance of the API client
with petstore_api.ApiClient(used_configuration) as api_client:
    # Create an instance of the API class
    api_instance = fake_api.FakeApi(api_client)

    # example, this endpoint has no required or optional parameters
    try:
        # slash route
        api_response = api_instance.slash_route()
        pprint(api_response)
    except petstore_api.ApiException as e:
        print("Exception when calling FakeApi->slash_route: %s\n" % e)
```

## Servers
server_index | Class | Description
------------ | ----- | ------------
0 | [Server0](docs/servers/server_0.md) | petstore server
1 | [Server1](docs/servers/server_1.md) | The local server
2 | [Server2](docs/servers/server_2.md) | staging server with no variables

## Endpoints

All URIs are relative to the selected server
- The server is selected by passing in server_info and server_index into api_configuration.ApiConfiguration
- Code samples in endpoints documents show how to do this
- server_index can also be passed in to endpoint calls, see endpoint documentation

HTTP request | Method | Description
------------ | ------ | -------------
/ **get** | [FakeApi](docs/apis/tags/fake_api.md).[slash_route](docs/paths/solidus/get.md)  | slash route
/another-fake/dummy **patch** | [AnotherFakeApi](docs/apis/tags/another_fake_api.md).[call_123_test__special_tags](docs/paths/another_fake_dummy/patch.md)  | To test special tags
/commonParam/{subDir}/ **delete** | [FakeApi](docs/apis/tags/fake_api.md).[delete_common_param](docs/paths/common_param_sub_dir/delete.md)  | 
/commonParam/{subDir}/ **get** | [FakeApi](docs/apis/tags/fake_api.md).[get_common_param](docs/paths/common_param_sub_dir/get.md)  | 
/commonParam/{subDir}/ **post** | [FakeApi](docs/apis/tags/fake_api.md).[post_common_param](docs/paths/common_param_sub_dir/post.md)  | 
/fake **delete** | [FakeApi](docs/apis/tags/fake_api.md).[group_parameters](docs/paths/fake/delete.md)  | Fake endpoint to test group parameters (optional)
/fake **get** | [FakeApi](docs/apis/tags/fake_api.md).[enum_parameters](docs/paths/fake/get.md)  | To test enum parameters
/fake **patch** | [FakeApi](docs/apis/tags/fake_api.md).[client_model](docs/paths/fake/patch.md)  | To test &quot;client&quot; model
/fake **post** | [FakeApi](docs/apis/tags/fake_api.md).[endpoint_parameters](docs/paths/fake/post.md)  | Fake endpoint for testing various parameters<br>假端點<br>偽のエンドポイント<br>가짜 엔드 포인트<br>
/fake/additional-properties-with-array-of-enums **get** | [FakeApi](docs/apis/tags/fake_api.md).[additional_properties_with_array_of_enums](docs/paths/fake_additional_properties_with_array_of_enums/get.md)  | Additional Properties with Array of Enums
/fake/body-with-file-schema **put** | [FakeApi](docs/apis/tags/fake_api.md).[body_with_file_schema](docs/paths/fake_body_with_file_schema/put.md)  | 
/fake/body-with-query-params **put** | [FakeApi](docs/apis/tags/fake_api.md).[body_with_query_params](docs/paths/fake_body_with_query_params/put.md)  | 
/fake/case-sensitive-params **put** | [FakeApi](docs/apis/tags/fake_api.md).[case_sensitive_params](docs/paths/fake_case_sensitive_params/put.md)  | 
/fake/deleteCoffee/{id} **delete** | [FakeApi](docs/apis/tags/fake_api.md).[delete_coffee](docs/paths/fake_delete_coffee_id/delete.md)  | Delete coffee
/fake/health **get** | [FakeApi](docs/apis/tags/fake_api.md).[fake_health_get](docs/paths/fake_health/get.md)  | Health check endpoint
/fake/inline-additionalProperties **post** | [FakeApi](docs/apis/tags/fake_api.md).[inline_additional_properties](docs/paths/fake_inline_additional_properties/post.md)  | test inline additionalProperties
/fake/inlineComposition/ **post** | [FakeApi](docs/apis/tags/fake_api.md).[inline_composition](docs/paths/fake_inline_composition/post.md)  | testing composed schemas at inline locations
/fake/jsonFormData **get** | [FakeApi](docs/apis/tags/fake_api.md).[json_form_data](docs/paths/fake_json_form_data/get.md)  | test json serialization of form data
/fake/jsonPatch **patch** | [FakeApi](docs/apis/tags/fake_api.md).[json_patch](docs/paths/fake_json_patch/patch.md)  | json patch
/fake/jsonWithCharset **post** | [FakeApi](docs/apis/tags/fake_api.md).[json_with_charset](docs/paths/fake_json_with_charset/post.md)  | json with charset tx and rx
/fake/multipleRequestBodyContentTypes/ **post** | [FakeApi](docs/apis/tags/fake_api.md).[multiple_request_body_content_types](docs/paths/fake_multiple_request_body_content_types/post.md)  | testing composed schemas at inline locations
/fake/multipleResponseBodies **get** | [FakeApi](docs/apis/tags/fake_api.md).[multiple_response_bodies](docs/paths/fake_multiple_response_bodies/get.md)  | multiple responses have response bodies
/fake/multipleSecurities **get** | [FakeApi](docs/apis/tags/fake_api.md).[multiple_securities](docs/paths/fake_multiple_securities/get.md)  | multiple security requirements
/fake/objInQuery **get** | [FakeApi](docs/apis/tags/fake_api.md).[object_in_query](docs/paths/fake_obj_in_query/get.md)  | user list
/fake/parameterCollisions/{1}/{aB}/{Ab}/{self}/{A-B}/ **post** | [FakeApi](docs/apis/tags/fake_api.md).[parameter_collisions](docs/paths/fake_parameter_collisions1_abab_self_ab/post.md)  | parameter collision case
/fake/pemContentType **get** | [FakeApi](docs/apis/tags/fake_api.md).[pem_content_type](docs/paths/fake_pem_content_type/get.md)  | route with tx and rx pem content type
/fake/queryParamWithJsonContentType **get** | [FakeApi](docs/apis/tags/fake_api.md).[query_param_with_json_content_type](docs/paths/fake_query_param_with_json_content_type/get.md)  | query param with json content-type
/fake/redirection **get** | [FakeApi](docs/apis/tags/fake_api.md).[redirection](docs/paths/fake_redirection/get.md)  | operation with redirection responses
/fake/refObjInQuery **get** | [FakeApi](docs/apis/tags/fake_api.md).[ref_object_in_query](docs/paths/fake_ref_obj_in_query/get.md)  | user list
/fake/refs/array-of-enums **post** | [FakeApi](docs/apis/tags/fake_api.md).[array_of_enums](docs/paths/fake_refs_array_of_enums/post.md)  | Array of Enums
/fake/refs/arraymodel **post** | [FakeApi](docs/apis/tags/fake_api.md).[array_model](docs/paths/fake_refs_arraymodel/post.md)  | 
/fake/refs/boolean **post** | [FakeApi](docs/apis/tags/fake_api.md).[boolean](docs/paths/fake_refs_boolean/post.md)  | 
/fake/refs/composed_one_of_number_with_validations **post** | [FakeApi](docs/apis/tags/fake_api.md).[composed_one_of_different_types](docs/paths/fake_refs_composed_one_of_number_with_validations/post.md)  | 
/fake/refs/enum **post** | [FakeApi](docs/apis/tags/fake_api.md).[string_enum](docs/paths/fake_refs_enum/post.md)  | 
/fake/refs/mammal **post** | [FakeApi](docs/apis/tags/fake_api.md).[mammal](docs/paths/fake_refs_mammal/post.md)  | 
/fake/refs/number **post** | [FakeApi](docs/apis/tags/fake_api.md).[number_with_validations](docs/paths/fake_refs_number/post.md)  | 
/fake/refs/object_model_with_ref_props **post** | [FakeApi](docs/apis/tags/fake_api.md).[object_model_with_ref_props](docs/paths/fake_refs_object_model_with_ref_props/post.md)  | 
/fake/refs/string **post** | [FakeApi](docs/apis/tags/fake_api.md).[string](docs/paths/fake_refs_string/post.md)  | 
/fake/responseWithoutSchema **get** | [FakeApi](docs/apis/tags/fake_api.md).[response_without_schema](docs/paths/fake_response_without_schema/get.md)  | receives a response without schema
/fake/test-query-paramters **put** | [FakeApi](docs/apis/tags/fake_api.md).[query_parameter_collection_format](docs/paths/fake_test_query_paramters/put.md)  | 
/fake/uploadDownloadFile **post** | [FakeApi](docs/apis/tags/fake_api.md).[upload_download_file](docs/paths/fake_upload_download_file/post.md)  | uploads a file and downloads a file using application/octet-stream
/fake/uploadFile **post** | [FakeApi](docs/apis/tags/fake_api.md).[upload_file](docs/paths/fake_upload_file/post.md)  | uploads a file using multipart/form-data
/fake/uploadFiles **post** | [FakeApi](docs/apis/tags/fake_api.md).[upload_files](docs/paths/fake_upload_files/post.md)  | uploads files using multipart/form-data
/fake/wildCardResponses **get** | [FakeApi](docs/apis/tags/fake_api.md).[wild_card_responses](docs/paths/fake_wild_card_responses/get.md)  | operation with wildcard responses
/fake/{petId}/uploadImageWithRequiredFile **post** | [PetApi](docs/apis/tags/pet_api.md).[upload_file_with_required_file](docs/paths/fake_pet_id_upload_image_with_required_file/post.md)  | uploads an image (required)
/fake_classname_test **patch** | [FakeClassnameTags123Api](docs/apis/tags/fake_classname_tags123_api.md).[classname](docs/paths/fake_classname_test/patch.md)  | To test class name in snake case
/foo **get** | [DefaultApi](docs/apis/tags/default_api.md).[foo_get](docs/paths/foo/get.md)  | 
/pet **post** | [PetApi](docs/apis/tags/pet_api.md).[add_pet](docs/paths/pet/post.md)  | Add a new pet to the store
/pet **put** | [PetApi](docs/apis/tags/pet_api.md).[update_pet](docs/paths/pet/put.md)  | Update an existing pet
/pet/findByStatus **get** | [PetApi](docs/apis/tags/pet_api.md).[find_pets_by_status](docs/paths/pet_find_by_status/get.md)  | Finds Pets by status
/pet/findByTags **get** | [PetApi](docs/apis/tags/pet_api.md).[find_pets_by_tags](docs/paths/pet_find_by_tags/get.md)  | Finds Pets by tags
/pet/{petId} **delete** | [PetApi](docs/apis/tags/pet_api.md).[delete_pet](docs/paths/pet_pet_id/delete.md)  | Deletes a pet
/pet/{petId} **get** | [PetApi](docs/apis/tags/pet_api.md).[get_pet_by_id](docs/paths/pet_pet_id/get.md)  | Find pet by ID
/pet/{petId} **post** | [PetApi](docs/apis/tags/pet_api.md).[update_pet_with_form](docs/paths/pet_pet_id/post.md)  | Updates a pet in the store with form data
/pet/{petId}/uploadImage **post** | [PetApi](docs/apis/tags/pet_api.md).[upload_image](docs/paths/pet_pet_id_upload_image/post.md)  | uploads an image
/store/inventory **get** | [StoreApi](docs/apis/tags/store_api.md).[get_inventory](docs/paths/store_inventory/get.md)  | Returns pet inventories by status
/store/order **post** | [StoreApi](docs/apis/tags/store_api.md).[place_order](docs/paths/store_order/post.md)  | Place an order for a pet
/store/order/{order_id} **delete** | [StoreApi](docs/apis/tags/store_api.md).[delete_order](docs/paths/store_order_order_id/delete.md)  | Delete purchase order by ID
/store/order/{order_id} **get** | [StoreApi](docs/apis/tags/store_api.md).[get_order_by_id](docs/paths/store_order_order_id/get.md)  | Find purchase order by ID
/user **post** | [UserApi](docs/apis/tags/user_api.md).[create_user](docs/paths/user/post.md)  | Create user
/user/createWithArray **post** | [UserApi](docs/apis/tags/user_api.md).[create_users_with_array_input](docs/paths/user_create_with_array/post.md)  | Creates list of users with given input array
/user/createWithList **post** | [UserApi](docs/apis/tags/user_api.md).[create_users_with_list_input](docs/paths/user_create_with_list/post.md)  | Creates list of users with given input array
/user/login **get** | [UserApi](docs/apis/tags/user_api.md).[login_user](docs/paths/user_login/get.md)  | Logs user into the system
/user/logout **get** | [UserApi](docs/apis/tags/user_api.md).[logout_user](docs/paths/user_logout/get.md)  | Logs out current logged in user session
/user/{username} **delete** | [UserApi](docs/apis/tags/user_api.md).[delete_user](docs/paths/user_username/delete.md)  | Delete user
/user/{username} **get** | [UserApi](docs/apis/tags/user_api.md).[get_user_by_name](docs/paths/user_username/get.md)  | Get user by user name
/user/{username} **put** | [UserApi](docs/apis/tags/user_api.md).[update_user](docs/paths/user_username/put.md)  | Updated user

## Component Schemas

Class | Description
----- | ------------
[_200Response](docs/components/schema/_200_response.md) | model with an invalid class name for python, starts with a number
[AbstractStepMessage](docs/components/schema/abstract_step_message.md) | Abstract Step
[AdditionalPropertiesClass](docs/components/schema/additional_properties_class.md) |
[AdditionalPropertiesSchema](docs/components/schema/additional_properties_schema.md) |
[AdditionalPropertiesWithArrayOfEnums](docs/components/schema/additional_properties_with_array_of_enums.md) |
[Address](docs/components/schema/address.md) |
[Animal](docs/components/schema/animal.md) |
[AnimalFarm](docs/components/schema/animal_farm.md) |
[AnyTypeAndFormat](docs/components/schema/any_type_and_format.md) |
[AnyTypeNotString](docs/components/schema/any_type_not_string.md) |
[ApiResponse](docs/components/schema/api_response.md) |
[ArrayHoldingAnyType](docs/components/schema/array_holding_any_type.md) |
[ArrayOfArrayOfNumberOnly](docs/components/schema/array_of_array_of_number_only.md) |
[ArrayOfEnums](docs/components/schema/array_of_enums.md) |
[ArrayOfNumberOnly](docs/components/schema/array_of_number_only.md) |
[ArrayTest](docs/components/schema/array_test.md) |
[ArrayWithValidationsInItems](docs/components/schema/array_with_validations_in_items.md) |
[Bar](docs/components/schema/bar.md) |
[BasquePig](docs/components/schema/basque_pig.md) |
[Boolean](docs/components/schema/boolean.md) |
[BooleanEnum](docs/components/schema/boolean_enum.md) |
[Capitalization](docs/components/schema/capitalization.md) |
[Cat](docs/components/schema/cat.md) |
[Category](docs/components/schema/category.md) |
[ChildCat](docs/components/schema/child_cat.md) |
[ClassModel](docs/components/schema/class_model.md) | Model for testing model with &quot;_class&quot; property
[Client](docs/components/schema/client.md) |
[ComplexQuadrilateral](docs/components/schema/complex_quadrilateral.md) |
[ComposedAnyOfDifferentTypesNoValidations](docs/components/schema/composed_any_of_different_types_no_validations.md) |
[ComposedArray](docs/components/schema/composed_array.md) |
[ComposedBool](docs/components/schema/composed_bool.md) |
[ComposedNone](docs/components/schema/composed_none.md) |
[ComposedNumber](docs/components/schema/composed_number.md) |
[ComposedObject](docs/components/schema/composed_object.md) |
[ComposedOneOfDifferentTypes](docs/components/schema/composed_one_of_different_types.md) | this is a model that allows payloads of type object or number
[ComposedString](docs/components/schema/composed_string.md) |
[Currency](docs/components/schema/currency.md) |
[DanishPig](docs/components/schema/danish_pig.md) |
[DateTimeTest](docs/components/schema/date_time_test.md) |
[DateTimeWithValidations](docs/components/schema/date_time_with_validations.md) |
[DateWithValidations](docs/components/schema/date_with_validations.md) |
[DecimalPayload](docs/components/schema/decimal_payload.md) |
[Dog](docs/components/schema/dog.md) |
[Drawing](docs/components/schema/drawing.md) |
[EnumArrays](docs/components/schema/enum_arrays.md) |
[EnumClass](docs/components/schema/enum_class.md) |
[EnumTest](docs/components/schema/enum_test.md) |
[EquilateralTriangle](docs/components/schema/equilateral_triangle.md) |
[File](docs/components/schema/file.md) | Must be named &#x60;File&#x60; for test.
[FileSchemaTestClass](docs/components/schema/file_schema_test_class.md) |
[Foo](docs/components/schema/foo.md) |
[FormatTest](docs/components/schema/format_test.md) |
[FromSchema](docs/components/schema/from_schema.md) |
[GrandparentAnimal](docs/components/schema/grandparent_animal.md) |
[HealthCheckResult](docs/components/schema/health_check_result.md) | Just a string to inform instance is up and running. Make it nullable in hope to get it as pointer in generated model.
[IntegerEnum](docs/components/schema/integer_enum.md) |
[IntegerEnumBig](docs/components/schema/integer_enum_big.md) |
[IntegerEnumOneValue](docs/components/schema/integer_enum_one_value.md) |
[IntegerEnumWithDefaultValue](docs/components/schema/integer_enum_with_default_value.md) |
[IntegerMax10](docs/components/schema/integer_max10.md) |
[IntegerMin15](docs/components/schema/integer_min15.md) |
[IsoscelesTriangle](docs/components/schema/isosceles_triangle.md) |
[Items](docs/components/schema/items.md) | component&#x27;s name collides with the inner schema name
[ItemsSchema](docs/components/schema/items_schema.md) |
[JSONPatchRequest](docs/components/schema/json_patch_request.md) |
[JSONPatchRequestAddReplaceTest](docs/components/schema/json_patch_request_add_replace_test.md) |
[JSONPatchRequestMoveCopy](docs/components/schema/json_patch_request_move_copy.md) |
[JSONPatchRequestRemove](docs/components/schema/json_patch_request_remove.md) |
[MapTest](docs/components/schema/map_test.md) |
[MixedPropertiesAndAdditionalPropertiesClass](docs/components/schema/mixed_properties_and_additional_properties_class.md) |
[Money](docs/components/schema/money.md) |
[MultiPropertiesSchema](docs/components/schema/multi_properties_schema.md) |
[MyObjectDto](docs/components/schema/my_object_dto.md) |
[Name](docs/components/schema/name.md) | Model for testing model name same as property name
[NoAdditionalProperties](docs/components/schema/no_additional_properties.md) |
[NullableClass](docs/components/schema/nullable_class.md) |
[NullableShape](docs/components/schema/nullable_shape.md) | The value may be a shape or the &#x27;null&#x27; value. For a composed schema to validate a null payload, one of its chosen oneOf schemas must be type null or nullable (introduced in OAS schema &gt;&#x3D; 3.0)
[NullableString](docs/components/schema/nullable_string.md) |
[Number](docs/components/schema/number.md) |
[NumberOnly](docs/components/schema/number_only.md) |
[NumberWithExclusiveMinMax](docs/components/schema/number_with_exclusive_min_max.md) |
[NumberWithValidations](docs/components/schema/number_with_validations.md) |
[ObjWithRequiredProps](docs/components/schema/obj_with_required_props.md) |
[ObjWithRequiredPropsBase](docs/components/schema/obj_with_required_props_base.md) |
[ObjectInterface](docs/components/schema/object_interface.md) |
[ObjectModelWithArgAndArgsProperties](docs/components/schema/object_model_with_arg_and_args_properties.md) |
[ObjectModelWithRefProps](docs/components/schema/object_model_with_ref_props.md) | a model that includes properties which should stay primitive (String + Boolean) and one which is defined as a class, NumberWithValidations
[ObjectWithAllOfWithReqTestPropFromUnsetAddProp](docs/components/schema/object_with_all_of_with_req_test_prop_from_unset_add_prop.md) |
[ObjectWithCollidingProperties](docs/components/schema/object_with_colliding_properties.md) | component with properties that have name collisions
[ObjectWithDecimalProperties](docs/components/schema/object_with_decimal_properties.md) |
[ObjectWithDifficultlyNamedProps](docs/components/schema/object_with_difficultly_named_props.md) | model with properties that have invalid names for python
[ObjectWithInlineCompositionProperty](docs/components/schema/object_with_inline_composition_property.md) |
[ObjectWithInvalidNamedRefedProperties](docs/components/schema/object_with_invalid_named_refed_properties.md) |
[ObjectWithNonIntersectingValues](docs/components/schema/object_with_non_intersecting_values.md) |
[ObjectWithOnlyOptionalProps](docs/components/schema/object_with_only_optional_props.md) |
[ObjectWithOptionalTestProp](docs/components/schema/object_with_optional_test_prop.md) |
[ObjectWithValidations](docs/components/schema/object_with_validations.md) |
[Order](docs/components/schema/order.md) |
[PaginatedResultMyObjectDto](docs/components/schema/paginated_result_my_object_dto.md) |
[ParentPet](docs/components/schema/parent_pet.md) |
[Pet](docs/components/schema/pet.md) | Pet object that needs to be added to the store
[Pig](docs/components/schema/pig.md) |
[Player](docs/components/schema/player.md) | a model that includes a self reference this forces properties and additionalProperties to be lazy loaded in python models because the Player class has not fully loaded when defining properties
[PublicKey](docs/components/schema/public_key.md) | schema that contains a property named key
[Quadrilateral](docs/components/schema/quadrilateral.md) |
[QuadrilateralInterface](docs/components/schema/quadrilateral_interface.md) |
[ReadOnlyFirst](docs/components/schema/read_only_first.md) |
[RefPet](docs/components/schema/ref_pet.md) |
[ReqPropsFromExplicitAddProps](docs/components/schema/req_props_from_explicit_add_props.md) |
[ReqPropsFromTrueAddProps](docs/components/schema/req_props_from_true_add_props.md) |
[ReqPropsFromUnsetAddProps](docs/components/schema/req_props_from_unset_add_props.md) |
[_Return](docs/components/schema/_return.md) | Model for testing reserved words
[ScaleneTriangle](docs/components/schema/scalene_triangle.md) |
[SelfReferencingArrayModel](docs/components/schema/self_referencing_array_model.md) |
[SelfReferencingObjectModel](docs/components/schema/self_referencing_object_model.md) |
[Shape](docs/components/schema/shape.md) |
[ShapeOrNull](docs/components/schema/shape_or_null.md) | The value may be a shape or the &#x27;null&#x27; value. This is introduced in OAS schema &gt;&#x3D; 3.1.
[SimpleQuadrilateral](docs/components/schema/simple_quadrilateral.md) |
[SomeObject](docs/components/schema/some_object.md) |
[String](docs/components/schema/string.md) |
[StringBooleanMap](docs/components/schema/string_boolean_map.md) |
[StringEnum](docs/components/schema/string_enum.md) |
[StringEnumWithDefaultValue](docs/components/schema/string_enum_with_default_value.md) |
[StringWithValidation](docs/components/schema/string_with_validation.md) |
[Tag](docs/components/schema/tag.md) |
[Triangle](docs/components/schema/triangle.md) |
[TriangleInterface](docs/components/schema/triangle_interface.md) |
[UUIDString](docs/components/schema/uuid_string.md) |
[User](docs/components/schema/user.md) |
[SpecialModelName](docs/components/schema/special_model_name.md) | model with an invalid class name for python
[Apple](docs/components/schema/apple.md) |
[AppleReq](docs/components/schema/apple_req.md) |
[Banana](docs/components/schema/banana.md) |
[BananaReq](docs/components/schema/banana_req.md) |
[Fruit](docs/components/schema/fruit.md) |
[FruitReq](docs/components/schema/fruit_req.md) |
[GmFruit](docs/components/schema/gm_fruit.md) |
[HasOnlyReadOnly](docs/components/schema/has_only_read_only.md) |
[Mammal](docs/components/schema/mammal.md) |
[Whale](docs/components/schema/whale.md) |
[Zebra](docs/components/schema/zebra.md) |

## Component RequestBodies

Class | Description
----- | ------------
[Client](docs/components/request_bodies/request_body_client.md) | client model
[Pet](docs/components/request_bodies/request_body_pet.md) | Pet object that needs to be added to the store, multiple content types
[RefUserArray](docs/components/request_bodies/request_body_ref_user_array.md) |
[UserArray](docs/components/request_bodies/request_body_user_array.md) | List of user object

## Component Responses

Class | Description
----- | ------------
[HeadersWithNoBody](docs/components/responses/response_headers_with_no_body.md) | A response that contains headers but no body<br>
[RefSuccessDescriptionOnly](docs/components/responses/response_ref_success_description_only.md) |
[RefSuccessfulXmlAndJsonArrayOfPet](docs/components/responses/response_ref_successful_xml_and_json_array_of_pet.md) |
[SuccessDescriptionOnly](docs/components/responses/response_success_description_only.md) | Success
[SuccessInlineContentAndHeader](docs/components/responses/response_success_inline_content_and_header.md) | successful operation
[SuccessWithJsonApiResponse](docs/components/responses/response_success_with_json_api_response.md) | successful operation
[SuccessfulXmlAndJsonArrayOfPet](docs/components/responses/response_successful_xml_and_json_array_of_pet.md) | successful operation, multiple content types

## Component Headers

Class | Description
----- | ------------
[Int32JsonContentTypeHeader](docs/components/headers/header_int32_json_content_type_header.md) | int32 JSON content-type header
[NumberHeader](docs/components/headers/header_number_header.md) | number header description
[RefContentSchemaHeader](docs/components/headers/header_ref_content_schema_header.md) | int32 JSON content-type header
[RefSchemaHeader](docs/components/headers/header_ref_schema_header.md) | header that has a ref in the schema
[RefStringHeader](docs/components/headers/header_ref_string_header.md) |
[StringHeader](docs/components/headers/header_string_header.md) | string header description

## Component Parameters

Class | Description
----- | ------------
[ComponentRefSchemaStringWithValidation](docs/components/parameters/parameter_component_ref_schema_string_with_validation.md) | a path string with validation
[PathUserName](docs/components/parameters/parameter_path_user_name.md) | the use name to use
[RefPathUserName](docs/components/parameters/parameter_ref_path_user_name.md) |
[RefSchemaStringWithValidation](docs/components/parameters/parameter_ref_schema_string_with_validation.md) | a path string with validation

## Component SecuritySchemes

Class | Description
----- | ------------
[ApiKey](docs/components/security_schemes/security_scheme_api_key.md) | apiKey in header
[ApiKeyQuery](docs/components/security_schemes/security_scheme_api_key_query.md) | apiKey in query
[BearerTest](docs/components/security_schemes/security_scheme_bearer_test.md) | http bearer with JWT bearer format
[HttpBasicTest](docs/components/security_schemes/security_scheme_http_basic_test.md) | http basic
[HttpSignatureTest](docs/components/security_schemes/security_scheme_http_signature_test.md) | http + signature
[OpenIdConnectTest](docs/components/security_schemes/security_scheme_open_id_connect_test.md) | openIdConnect
[PetstoreAuth](docs/components/security_schemes/security_scheme_petstore_auth.md) | oauth2 implicit flow with two scopes


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in petstore_api.apis.tags.tag_to_api and petstore_api.components.schemas may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- tagged api: `from petstore_api.apis.tags.default_api import DefaultApi`
- api for one path: `from petstore_api.apis.paths.some_path import SomePath`
- api for one operation (path + verb): `from petstore_api.paths.some_path.get import ApiForget`
- single model import: `from petstore_api.components.schema.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import petstore_api
from petstore_api.apis.tags.tag_to_api import *
from petstore_api.components.schemas import *
```
