# petstore
This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose.

This Java package is automatically generated by the [OpenAPI JSON Schema Generator](https://github.com/openapi-json-schema-tools/openapi-json-schema-generator) project:

- OpenAPI document version: 1.0.0
- Java Package version: 1.0.0
- OpenAPI JSON Schema Generator, Generator: JavaClientGenerator

## Requirements

1. Java 17
2. Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
gradle wrapper
gradlew clean build
```

### Gradle users

Add this dependency to your project's build file:

```
repositories {
    mavenCentral()     // Needed if the 'petstore' jar has been published to maven centra
    mavenLocal()       // Needed if the 'petstore' jar has been published to the local maven repo
}

dependencies {
     implementation "org.openapijsonschematools:petstore:1.0.0"
}
```


## Usage Notes
### Validation, Immutability, and Data Type
This Java code validates data to schema classes and return back an immutable instance containing the data. This ensure that
- valid data cannot be mutated and become invalid to a set of schemas
  - the one exception is that files are not immutable, so schema instances storing/sending/receiving files are not immutable

Here is the mapping from json schema types to Java types:

| Json Schema Type | Java Base Class |
| ---------------- | --------------- |
| object           | FrozenMap (Map) |
| array            | FrozenList (List) |
| string           | String |
| number           | Number (int, long, float, double) |
| integer          | int, long, float, double (with values equal to integers) |
| boolean          | boolean |
| null             | Void (null) |
| AnyType (unset)  | @Nullable Object |

### Storage of Json Schema Definition in Java JsonSchema Classes
In openapi v3.0.3 there are ~ 28 json schema keywords. Almost all of them can apply if
type is unset. I have chosen to separate the storage of
- json schema definition info
- output classes for validated Map (json schema type object) payloads
- output classes for validated List (json schema type array) payloads

<details>
  <summary>Reason</summary>

This json schema data is stored in each class that is written for a schema, in a component or
other openapi document location. This class is only responsible for storing schema info.
Output classes like those that store map payloads are written separately and are
returned by the JsonSchema.validate method when that method is passed in Map input.
This prevents payload property access methods from
colliding with json schema definition.
</details>

### Json Schema Type Object
Most component schemas (models) are probably of type object. Which is a map data structure.
Json schema allows string keys in this map, which means schema properties can have key names that are
invalid Java variable names. Names like:
- "hi-there"
- "1variable"
- "@now"
- " "
- "from"

To allow these use cases to work, FrozenMap (which extends AbstractMap) is used as the base class of type object schemas.
This means that one can use normal Map methods on instances of these classes.

<details>
  <summary>Other Details</summary>

- getters are written for validly named required and optional properties
- null is only allowed in as a value if type: "null" was included or nullable: true was set
  - because null is an allowed property value, it is not used to represent an unset property state
- if an optional property is requested and it does not exist in the Map, an UnsetPropertyException is thrown
</details>

### Json Schema Type + Format, Validated Data Storage
N schemas can be validated on the same payload.
To allow multiple schemas to validate, the data must be stored using one base class whether or not
a json schema format constraint exists in the schema.

In json schema, type: number with no format validates both integers and floats,
so int and float values are stored for type number.

<details>
  <summary>String + Date Example</summary>

For example the string payload '2023-12-20' is validates to both of these schemas:
1. string only
```
- type: string
```
2. string and date format
```
- type: string
  format: date
```
Because of use cases like this, a LocalDate is allowed as an input to this schema, but the data
is stored as a string.
</details>

## Getting Started

Please follow the [installation procedure](#installation) and then use the JsonSchema classes in
org.openapijsonschematools.client.components.schemas to validate input payloads and instances of validated Map and List
output classes. Json schemas allow multiple types for one schema, so a schema's validate method can have
allowed input and output types.

## Code Sample
```
import org.openapijsonschematools.client.configurations.ApiConfiguration;
import org.openapijsonschematools.client.configurations.SchemaConfiguration;
import org.openapijsonschematools.client.configurations.JsonSchemaKeywordFlags;
import org.openapijsonschematools.client.exceptions.ValidationException;
import org.openapijsonschematools.client.exceptions.NotImplementedException;
import org.openapijsonschematools.client.exceptions.ApiException;
import org.openapijsonschematools.client.schemas.validation.MapUtils;
import org.openapijsonschematools.client.schemas.validation.FrozenList;
import org.openapijsonschematools.client.schemas.validation.FrozenMap;
import org.openapijsonschematools.client.RootServerInfo;
import org.openapijsonschematools.client.servers.RootServer0;
import org.openapijsonschematools.client.servers.RootServer1;
import org.openapijsonschematools.client.servers.RootServer2;
import org.openapijsonschematools.client.paths.solidus.get.responses.SolidusGetCode200Response;
import org.openapijsonschematools.client.servers.RootServerInfo;
import org.openapijsonschematools.client.apis.tags.Fake;
import org.openapijsonschematools.client.paths.solidus.get.SolidusGetResponses;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.AbstractMap;

// if you want to use a server that is not SERVER_0 pass it in here and change the ServerIndex input below
ApiConfiguration.ServerInfo serverInfo = new ApiConfiguration.ServerInfoBuilder()
    .rootServerInfo(
        new RootServerInfo.RootServerInfoBuilder()
            .rootServer0(new RootServer0())
            .build()
    )
    .build();
ApiConfiguration.ServerIndexInfo serverIndexInfo = new ApiConfiguration.ServerIndexInfoBuilder()
    .rootServerInfoServerIndex(RootServerInfo.ServerIndex.SERVER_0)
    .build();
Duration timeout = Duration.ofSeconds(1L);
Map<String, List<String>> defaultHeaders = Map.of("User-Agent", List.of("OpenAPI-JSON-Schema-Generator/1.0.0/java"));
ApiConfiguration apiConfiguration = new ApiConfiguration(
    serverInfo
    serverIndexInfo,
    timeout,
    defaultHeaders
);
SchemaConfiguration schemaConfiguration = new SchemaConfiguration(new JsonSchemaKeywordFlags.Builder().build());
Fake apiClient = new Fake(apiConfiguration, schemaConfiguration);


var request = new SolidusGet.GetRequestBuilder().build();

SolidusGetResponses.EndpointResponse response;
try {
    response = apiClient.get(request);
} catch (ApiException e) {
    // server returned a response/contentType not defined in the openapi document
    throw e;
} catch (ValidationException e) {
    // the returned response body or header values do not conform the the schema validation requirements
    throw e;
} catch (IOException | InterruptedException e) {
    // an exception happened when making the request
    throw e;
} catch (NotImplementedException e) {
    // the request body serialization or deserialization has not yet been implemented
    // or the header content type deserialization has not yet been implemented for this contentType
    throw e;
}
SolidusGetResponses.EndpointSolidusGetCode200Response castResponse = (SolidusGetResponses.EndpointSolidusGetCode200Response) response;
```
## Servers
| server_index | Class | Description |
| ------------ | ----- | ----------- |
| 0 | [RootServer0](docs/servers/RootServer0.md) | petstore server |
| 1 | [RootServer1](docs/servers/RootServer1.md) | The local server |
| 2 | [RootServer2](docs/servers/RootServer2.md) | staging server with no variables |

## Component SecuritySchemes
| Class | Description |
| ----- | ----------- |
| [ApiKey](docs/components/securityschemes/ApiKey.md) | apiKey in header |
| [ApiKeyQuery](docs/components/securityschemes/ApiKeyQuery.md) | apiKey in query |
| [BearerTest](docs/components/securityschemes/BearerTest.md) | http bearer with JWT bearer format |
| [HttpBasicTest](docs/components/securityschemes/HttpBasicTest.md) | http basic |
| [HttpSignatureTest](docs/components/securityschemes/HttpSignatureTest.md) | http + signature |
| [OpenIdConnectTest](docs/components/securityschemes/OpenIdConnectTest.md) | openIdConnect |
| [PetstoreAuth](docs/components/securityschemes/PetstoreAuth.md) | oauth2 implicit flow with two scopes |

## Endpoints
All URIs are relative to the selected server
- The server is selected by passing in serverInfo + serverIndexInfo into configurations.ApiConfiguration
- The security info is selected by passing in securityInfo + securityIndexInfo into configurations.ApiConfiguration
- serverIndex + securityIndex can also be passed in to endpoint calls, see endpoint documentation

| HTTP request | Methods | Description |
| ------------ | ------- | ----------- |
| / **get** | [Fake.slashRoute](docs/apis/tags/Fake.md#slashroute)  [Solidus.get](docs/apis/paths/Solidus.md#get) [SolidusGet.Get.get](docs/paths/solidus/SolidusGet.md#get) | slash route |
| /another-fake/dummy **patch** | [Anotherfake.model123TestSpecialTags](docs/apis/tags/Anotherfake.md#model123testspecialtags)  [Anotherfakedummy.patch](docs/apis/paths/Anotherfakedummy.md#patch) [AnotherfakedummyPatch.Patch.patch](docs/paths/anotherfakedummy/AnotherfakedummyPatch.md#patch) | To test special tags |
| /commonParam/{subDir}/ **delete** | [Fake.deleteCommonParam](docs/apis/tags/Fake.md#deletecommonparam)  [Commonparamsubdir.delete](docs/apis/paths/Commonparamsubdir.md#delete) [CommonparamsubdirDelete.Delete.delete](docs/paths/commonparamsubdir/CommonparamsubdirDelete.md#delete) | |
| /commonParam/{subDir}/ **get** | [Fake.getCommonParam](docs/apis/tags/Fake.md#getcommonparam)  [Commonparamsubdir.get](docs/apis/paths/Commonparamsubdir.md#get) [CommonparamsubdirGet.Get.get](docs/paths/commonparamsubdir/CommonparamsubdirGet.md#get) | |
| /commonParam/{subDir}/ **post** | [Fake.postCommonParam](docs/apis/tags/Fake.md#postcommonparam)  [Commonparamsubdir.post](docs/apis/paths/Commonparamsubdir.md#post) [CommonparamsubdirPost.Post.post](docs/paths/commonparamsubdir/CommonparamsubdirPost.md#post) | |
| /fake **delete** | [Fake.groupParameters](docs/apis/tags/Fake.md#groupparameters)  [Fake.delete](docs/apis/paths/Fake.md#delete) [FakeDelete.Delete.delete](docs/paths/fake/FakeDelete.md#delete) | Fake endpoint to test group parameters (optional) |
| /fake **get** | [Fake.enumParameters](docs/apis/tags/Fake.md#enumparameters)  [Fake.get](docs/apis/paths/Fake.md#get) [FakeGet.Get.get](docs/paths/fake/FakeGet.md#get) | To test enum parameters |
| /fake **patch** | [Fake.clientModel](docs/apis/tags/Fake.md#clientmodel)  [Fake.patch](docs/apis/paths/Fake.md#patch) [FakePatch.Patch.patch](docs/paths/fake/FakePatch.md#patch) | To test &quot;client&quot; model |
| /fake **post** | [Fake.endpointParameters](docs/apis/tags/Fake.md#endpointparameters)  [Fake.post](docs/apis/paths/Fake.md#post) [FakePost.Post.post](docs/paths/fake/FakePost.md#post) | Fake endpoint for testing various parameters<br>假端點<br>偽のエンドポイント<br>가짜 엔드 포인트<br> |
| /fake/additional-properties-with-array-of-enums **get** | [Fake.additionalPropertiesWithArrayOfEnums](docs/apis/tags/Fake.md#additionalpropertieswitharrayofenums)  [Fakeadditionalpropertieswitharrayofenums.get](docs/apis/paths/Fakeadditionalpropertieswitharrayofenums.md#get) [FakeadditionalpropertieswitharrayofenumsGet.Get.get](docs/paths/fakeadditionalpropertieswitharrayofenums/FakeadditionalpropertieswitharrayofenumsGet.md#get) | Additional Properties with Array of Enums |
| /fake/body-with-file-schema **put** | [Fake.bodyWithFileSchema](docs/apis/tags/Fake.md#bodywithfileschema)  [Fakebodywithfileschema.put](docs/apis/paths/Fakebodywithfileschema.md#put) [FakebodywithfileschemaPut.Put.put](docs/paths/fakebodywithfileschema/FakebodywithfileschemaPut.md#put) | |
| /fake/body-with-query-params **put** | [Fake.bodyWithQueryParams](docs/apis/tags/Fake.md#bodywithqueryparams)  [Fakebodywithqueryparams.put](docs/apis/paths/Fakebodywithqueryparams.md#put) [FakebodywithqueryparamsPut.Put.put](docs/paths/fakebodywithqueryparams/FakebodywithqueryparamsPut.md#put) | |
| /fake/case-sensitive-params **put** | [Fake.caseSensitiveParams](docs/apis/tags/Fake.md#casesensitiveparams)  [Fakecasesensitiveparams.put](docs/apis/paths/Fakecasesensitiveparams.md#put) [FakecasesensitiveparamsPut.Put.put](docs/paths/fakecasesensitiveparams/FakecasesensitiveparamsPut.md#put) | |
| /fake/deleteCoffee/{id} **delete** | [Fake.deleteCoffee](docs/apis/tags/Fake.md#deletecoffee)  [Fakedeletecoffeeid.delete](docs/apis/paths/Fakedeletecoffeeid.md#delete) [FakedeletecoffeeidDelete.Delete.delete](docs/paths/fakedeletecoffeeid/FakedeletecoffeeidDelete.md#delete) | Delete coffee |
| /fake/health **get** | [Fake.fakeHealthGet](docs/apis/tags/Fake.md#fakehealthget)  [Fakehealth.get](docs/apis/paths/Fakehealth.md#get) [FakehealthGet.Get.get](docs/paths/fakehealth/FakehealthGet.md#get) | Health check endpoint |
| /fake/inline-additionalProperties **post** | [Fake.inlineAdditionalProperties](docs/apis/tags/Fake.md#inlineadditionalproperties)  [Fakeinlineadditionalproperties.post](docs/apis/paths/Fakeinlineadditionalproperties.md#post) [FakeinlineadditionalpropertiesPost.Post.post](docs/paths/fakeinlineadditionalproperties/FakeinlineadditionalpropertiesPost.md#post) | test inline additionalProperties |
| /fake/inlineComposition/ **post** | [Fake.inlineComposition](docs/apis/tags/Fake.md#inlinecomposition)  [Fakeinlinecomposition.post](docs/apis/paths/Fakeinlinecomposition.md#post) [FakeinlinecompositionPost.Post.post](docs/paths/fakeinlinecomposition/FakeinlinecompositionPost.md#post) | testing composed schemas at inline locations |
| /fake/jsonFormData **get** | [Fake.jsonFormData](docs/apis/tags/Fake.md#jsonformdata)  [Fakejsonformdata.get](docs/apis/paths/Fakejsonformdata.md#get) [FakejsonformdataGet.Get.get](docs/paths/fakejsonformdata/FakejsonformdataGet.md#get) | test json serialization of form data |
| /fake/jsonPatch **patch** | [Fake.jsonPatch](docs/apis/tags/Fake.md#jsonpatch)  [Fakejsonpatch.patch](docs/apis/paths/Fakejsonpatch.md#patch) [FakejsonpatchPatch.Patch.patch](docs/paths/fakejsonpatch/FakejsonpatchPatch.md#patch) | json patch |
| /fake/jsonWithCharset **post** | [Fake.jsonWithCharset](docs/apis/tags/Fake.md#jsonwithcharset)  [Fakejsonwithcharset.post](docs/apis/paths/Fakejsonwithcharset.md#post) [FakejsonwithcharsetPost.Post.post](docs/paths/fakejsonwithcharset/FakejsonwithcharsetPost.md#post) | json with charset tx and rx |
| /fake/multipleRequestBodyContentTypes/ **post** | [Fake.multipleRequestBodyContentTypes](docs/apis/tags/Fake.md#multiplerequestbodycontenttypes)  [Fakemultiplerequestbodycontenttypes.post](docs/apis/paths/Fakemultiplerequestbodycontenttypes.md#post) [FakemultiplerequestbodycontenttypesPost.Post.post](docs/paths/fakemultiplerequestbodycontenttypes/FakemultiplerequestbodycontenttypesPost.md#post) | testing composed schemas at inline locations |
| /fake/multipleResponseBodies **get** | [Fake.multipleResponseBodies](docs/apis/tags/Fake.md#multipleresponsebodies)  [Fakemultipleresponsebodies.get](docs/apis/paths/Fakemultipleresponsebodies.md#get) [FakemultipleresponsebodiesGet.Get.get](docs/paths/fakemultipleresponsebodies/FakemultipleresponsebodiesGet.md#get) | multiple responses have response bodies |
| /fake/multipleSecurities **get** | [Fake.multipleSecurities](docs/apis/tags/Fake.md#multiplesecurities)  [Fakemultiplesecurities.get](docs/apis/paths/Fakemultiplesecurities.md#get) [FakemultiplesecuritiesGet.Get.get](docs/paths/fakemultiplesecurities/FakemultiplesecuritiesGet.md#get) | multiple security requirements |
| /fake/objInQuery **get** | [Fake.objectInQuery](docs/apis/tags/Fake.md#objectinquery)  [Fakeobjinquery.get](docs/apis/paths/Fakeobjinquery.md#get) [FakeobjinqueryGet.Get.get](docs/paths/fakeobjinquery/FakeobjinqueryGet.md#get) | user list |
| /fake/parameterCollisions/{1}/{aB}/{Ab}/{self}/{A-B}/ **post** | [Fake.parameterCollisions](docs/apis/tags/Fake.md#parametercollisions)  [Fakeparametercollisions1ababselfab.post](docs/apis/paths/Fakeparametercollisions1ababselfab.md#post) [Fakeparametercollisions1ababselfabPost.Post.post](docs/paths/fakeparametercollisions1ababselfab/Fakeparametercollisions1ababselfabPost.md#post) | parameter collision case |
| /fake/pemContentType **get** | [Fake.pemContentType](docs/apis/tags/Fake.md#pemcontenttype)  [Fakepemcontenttype.get](docs/apis/paths/Fakepemcontenttype.md#get) [FakepemcontenttypeGet.Get.get](docs/paths/fakepemcontenttype/FakepemcontenttypeGet.md#get) | route with tx and rx pem content type |
| /fake/queryParamWithJsonContentType **get** | [Fake.queryParamWithJsonContentType](docs/apis/tags/Fake.md#queryparamwithjsoncontenttype)  [Fakequeryparamwithjsoncontenttype.get](docs/apis/paths/Fakequeryparamwithjsoncontenttype.md#get) [FakequeryparamwithjsoncontenttypeGet.Get.get](docs/paths/fakequeryparamwithjsoncontenttype/FakequeryparamwithjsoncontenttypeGet.md#get) | query param with json content-type |
| /fake/redirection **get** | [Fake.redirection](docs/apis/tags/Fake.md#redirection)  [Fakeredirection.get](docs/apis/paths/Fakeredirection.md#get) [FakeredirectionGet.Get.get](docs/paths/fakeredirection/FakeredirectionGet.md#get) | operation with redirection responses |
| /fake/refObjInQuery **get** | [Fake.refObjectInQuery](docs/apis/tags/Fake.md#refobjectinquery)  [Fakerefobjinquery.get](docs/apis/paths/Fakerefobjinquery.md#get) [FakerefobjinqueryGet.Get.get](docs/paths/fakerefobjinquery/FakerefobjinqueryGet.md#get) | user list |
| /fake/refs/array-of-enums **post** | [Fake.arrayOfEnums](docs/apis/tags/Fake.md#arrayofenums)  [Fakerefsarrayofenums.post](docs/apis/paths/Fakerefsarrayofenums.md#post) [FakerefsarrayofenumsPost.Post.post](docs/paths/fakerefsarrayofenums/FakerefsarrayofenumsPost.md#post) | Array of Enums |
| /fake/refs/arraymodel **post** | [Fake.arrayModel](docs/apis/tags/Fake.md#arraymodel)  [Fakerefsarraymodel.post](docs/apis/paths/Fakerefsarraymodel.md#post) [FakerefsarraymodelPost.Post.post](docs/paths/fakerefsarraymodel/FakerefsarraymodelPost.md#post) | |
| /fake/refs/boolean **post** | [Fake.modelBoolean](docs/apis/tags/Fake.md#modelboolean)  [Fakerefsboolean.post](docs/apis/paths/Fakerefsboolean.md#post) [FakerefsbooleanPost.Post.post](docs/paths/fakerefsboolean/FakerefsbooleanPost.md#post) | |
| /fake/refs/composed_one_of_number_with_validations **post** | [Fake.composedOneOfDifferentTypes](docs/apis/tags/Fake.md#composedoneofdifferenttypes)  [Fakerefscomposedoneofnumberwithvalidations.post](docs/apis/paths/Fakerefscomposedoneofnumberwithvalidations.md#post) [FakerefscomposedoneofnumberwithvalidationsPost.Post.post](docs/paths/fakerefscomposedoneofnumberwithvalidations/FakerefscomposedoneofnumberwithvalidationsPost.md#post) | |
| /fake/refs/enum **post** | [Fake.stringEnum](docs/apis/tags/Fake.md#stringenum)  [Fakerefsenum.post](docs/apis/paths/Fakerefsenum.md#post) [FakerefsenumPost.Post.post](docs/paths/fakerefsenum/FakerefsenumPost.md#post) | |
| /fake/refs/mammal **post** | [Fake.mammal](docs/apis/tags/Fake.md#mammal)  [Fakerefsmammal.post](docs/apis/paths/Fakerefsmammal.md#post) [FakerefsmammalPost.Post.post](docs/paths/fakerefsmammal/FakerefsmammalPost.md#post) | |
| /fake/refs/number **post** | [Fake.numberWithValidations](docs/apis/tags/Fake.md#numberwithvalidations)  [Fakerefsnumber.post](docs/apis/paths/Fakerefsnumber.md#post) [FakerefsnumberPost.Post.post](docs/paths/fakerefsnumber/FakerefsnumberPost.md#post) | |
| /fake/refs/object_model_with_ref_props **post** | [Fake.objectModelWithRefProps](docs/apis/tags/Fake.md#objectmodelwithrefprops)  [Fakerefsobjectmodelwithrefprops.post](docs/apis/paths/Fakerefsobjectmodelwithrefprops.md#post) [FakerefsobjectmodelwithrefpropsPost.Post.post](docs/paths/fakerefsobjectmodelwithrefprops/FakerefsobjectmodelwithrefpropsPost.md#post) | |
| /fake/refs/string **post** | [Fake.modelString](docs/apis/tags/Fake.md#modelstring)  [Fakerefsstring.post](docs/apis/paths/Fakerefsstring.md#post) [FakerefsstringPost.Post.post](docs/paths/fakerefsstring/FakerefsstringPost.md#post) | |
| /fake/responseWithoutSchema **get** | [Fake.responseWithoutSchema](docs/apis/tags/Fake.md#responsewithoutschema)  [Fakeresponsewithoutschema.get](docs/apis/paths/Fakeresponsewithoutschema.md#get) [FakeresponsewithoutschemaGet.Get.get](docs/paths/fakeresponsewithoutschema/FakeresponsewithoutschemaGet.md#get) | receives a response without schema |
| /fake/test-query-paramters **put** | [Fake.queryParameterCollectionFormat](docs/apis/tags/Fake.md#queryparametercollectionformat)  [Faketestqueryparamters.put](docs/apis/paths/Faketestqueryparamters.md#put) [FaketestqueryparamtersPut.Put.put](docs/paths/faketestqueryparamters/FaketestqueryparamtersPut.md#put) | |
| /fake/uploadDownloadFile **post** | [Fake.uploadDownloadFile](docs/apis/tags/Fake.md#uploaddownloadfile)  [Fakeuploaddownloadfile.post](docs/apis/paths/Fakeuploaddownloadfile.md#post) [FakeuploaddownloadfilePost.Post.post](docs/paths/fakeuploaddownloadfile/FakeuploaddownloadfilePost.md#post) | uploads a file and downloads a file using application/octet-stream |
| /fake/uploadFile **post** | [Fake.uploadFile](docs/apis/tags/Fake.md#uploadfile)  [Fakeuploadfile.post](docs/apis/paths/Fakeuploadfile.md#post) [FakeuploadfilePost.Post.post](docs/paths/fakeuploadfile/FakeuploadfilePost.md#post) | uploads a file using multipart/form-data |
| /fake/uploadFiles **post** | [Fake.uploadFiles](docs/apis/tags/Fake.md#uploadfiles)  [Fakeuploadfiles.post](docs/apis/paths/Fakeuploadfiles.md#post) [FakeuploadfilesPost.Post.post](docs/paths/fakeuploadfiles/FakeuploadfilesPost.md#post) | uploads files using multipart/form-data |
| /fake/wildCardResponses **get** | [Fake.wildCardResponses](docs/apis/tags/Fake.md#wildcardresponses)  [Fakewildcardresponses.get](docs/apis/paths/Fakewildcardresponses.md#get) [FakewildcardresponsesGet.Get.get](docs/paths/fakewildcardresponses/FakewildcardresponsesGet.md#get) | operation with wildcard responses |
| /fake/{petId}/uploadImageWithRequiredFile **post** | [Pet.uploadFileWithRequiredFile](docs/apis/tags/Pet.md#uploadfilewithrequiredfile)  [Fakepetiduploadimagewithrequiredfile.post](docs/apis/paths/Fakepetiduploadimagewithrequiredfile.md#post) [FakepetiduploadimagewithrequiredfilePost.Post.post](docs/paths/fakepetiduploadimagewithrequiredfile/FakepetiduploadimagewithrequiredfilePost.md#post) | uploads an image (required) |
| /fake_classname_test **patch** | [Fakeclassnametags123.classname](docs/apis/tags/Fakeclassnametags123.md#classname)  [Fakeclassnametest.patch](docs/apis/paths/Fakeclassnametest.md#patch) [FakeclassnametestPatch.Patch.patch](docs/paths/fakeclassnametest/FakeclassnametestPatch.md#patch) | To test class name in snake case |
| /foo **get** | [Default.fooGet](docs/apis/tags/Default.md#fooget)  [Foo.get](docs/apis/paths/Foo.md#get) [FooGet.Get.get](docs/paths/foo/FooGet.md#get) | |
| /pet **post** | [Pet.addPet](docs/apis/tags/Pet.md#addpet)  [Pet.post](docs/apis/paths/Pet.md#post) [PetPost.Post.post](docs/paths/pet/PetPost.md#post) | Add a new pet to the store |
| /pet **put** | [Pet.updatePet](docs/apis/tags/Pet.md#updatepet)  [Pet.put](docs/apis/paths/Pet.md#put) [PetPut.Put.put](docs/paths/pet/PetPut.md#put) | Update an existing pet |
| /pet/findByStatus **get** | [Pet.findPetsByStatus](docs/apis/tags/Pet.md#findpetsbystatus)  [Petfindbystatus.get](docs/apis/paths/Petfindbystatus.md#get) [PetfindbystatusGet.Get.get](docs/paths/petfindbystatus/PetfindbystatusGet.md#get) | Finds Pets by status |
| /pet/findByTags **get** | [Pet.findPetsByTags](docs/apis/tags/Pet.md#findpetsbytags)  [Petfindbytags.get](docs/apis/paths/Petfindbytags.md#get) [PetfindbytagsGet.Get.get](docs/paths/petfindbytags/PetfindbytagsGet.md#get) | Finds Pets by tags |
| /pet/{petId} **delete** | [Pet.deletePet](docs/apis/tags/Pet.md#deletepet)  [Petpetid.delete](docs/apis/paths/Petpetid.md#delete) [PetpetidDelete.Delete.delete](docs/paths/petpetid/PetpetidDelete.md#delete) | Deletes a pet |
| /pet/{petId} **get** | [Pet.getPetById](docs/apis/tags/Pet.md#getpetbyid)  [Petpetid.get](docs/apis/paths/Petpetid.md#get) [PetpetidGet.Get.get](docs/paths/petpetid/PetpetidGet.md#get) | Find pet by ID |
| /pet/{petId} **post** | [Pet.updatePetWithForm](docs/apis/tags/Pet.md#updatepetwithform)  [Petpetid.post](docs/apis/paths/Petpetid.md#post) [PetpetidPost.Post.post](docs/paths/petpetid/PetpetidPost.md#post) | Updates a pet in the store with form data |
| /pet/{petId}/uploadImage **post** | [Pet.uploadImage](docs/apis/tags/Pet.md#uploadimage)  [Petpetiduploadimage.post](docs/apis/paths/Petpetiduploadimage.md#post) [PetpetiduploadimagePost.Post.post](docs/paths/petpetiduploadimage/PetpetiduploadimagePost.md#post) | uploads an image |
| /store/inventory **get** | [Store.getInventory](docs/apis/tags/Store.md#getinventory)  [Storeinventory.get](docs/apis/paths/Storeinventory.md#get) [StoreinventoryGet.Get.get](docs/paths/storeinventory/StoreinventoryGet.md#get) | Returns pet inventories by status |
| /store/order **post** | [Store.placeOrder](docs/apis/tags/Store.md#placeorder)  [Storeorder.post](docs/apis/paths/Storeorder.md#post) [StoreorderPost.Post.post](docs/paths/storeorder/StoreorderPost.md#post) | Place an order for a pet |
| /store/order/{order_id} **delete** | [Store.deleteOrder](docs/apis/tags/Store.md#deleteorder)  [Storeorderorderid.delete](docs/apis/paths/Storeorderorderid.md#delete) [StoreorderorderidDelete.Delete.delete](docs/paths/storeorderorderid/StoreorderorderidDelete.md#delete) | Delete purchase order by ID |
| /store/order/{order_id} **get** | [Store.getOrderById](docs/apis/tags/Store.md#getorderbyid)  [Storeorderorderid.get](docs/apis/paths/Storeorderorderid.md#get) [StoreorderorderidGet.Get.get](docs/paths/storeorderorderid/StoreorderorderidGet.md#get) | Find purchase order by ID |
| /user **post** | [User.createUser](docs/apis/tags/User.md#createuser)  [User.post](docs/apis/paths/User.md#post) [UserPost.Post.post](docs/paths/user/UserPost.md#post) | Create user |
| /user/createWithArray **post** | [User.createUsersWithArrayInput](docs/apis/tags/User.md#createuserswitharrayinput)  [Usercreatewitharray.post](docs/apis/paths/Usercreatewitharray.md#post) [UsercreatewitharrayPost.Post.post](docs/paths/usercreatewitharray/UsercreatewitharrayPost.md#post) | Creates list of users with given input array |
| /user/createWithList **post** | [User.createUsersWithListInput](docs/apis/tags/User.md#createuserswithlistinput)  [Usercreatewithlist.post](docs/apis/paths/Usercreatewithlist.md#post) [UsercreatewithlistPost.Post.post](docs/paths/usercreatewithlist/UsercreatewithlistPost.md#post) | Creates list of users with given input array |
| /user/login **get** | [User.loginUser](docs/apis/tags/User.md#loginuser)  [Userlogin.get](docs/apis/paths/Userlogin.md#get) [UserloginGet.Get.get](docs/paths/userlogin/UserloginGet.md#get) | Logs user into the system |
| /user/logout **get** | [User.logoutUser](docs/apis/tags/User.md#logoutuser)  [Userlogout.get](docs/apis/paths/Userlogout.md#get) [UserlogoutGet.Get.get](docs/paths/userlogout/UserlogoutGet.md#get) | Logs out current logged in user session |
| /user/{username} **delete** | [User.deleteUser](docs/apis/tags/User.md#deleteuser)  [Userusername.delete](docs/apis/paths/Userusername.md#delete) [UserusernameDelete.Delete.delete](docs/paths/userusername/UserusernameDelete.md#delete) | Delete user |
| /user/{username} **get** | [User.getUserByName](docs/apis/tags/User.md#getuserbyname)  [Userusername.get](docs/apis/paths/Userusername.md#get) [UserusernameGet.Get.get](docs/paths/userusername/UserusernameGet.md#get) | Get user by user name |
| /user/{username} **put** | [User.updateUser](docs/apis/tags/User.md#updateuser)  [Userusername.put](docs/apis/paths/Userusername.md#put) [UserusernamePut.Put.put](docs/paths/userusername/UserusernamePut.md#put) | Updated user |

## Component Schemas
| Class | Description |
| ----- | ----------- |
| [Schema200Response.Schema200Response1](docs/components/schemas/Schema200Response.md#schema200response1) | model with an invalid class name for python, starts with a number |
| [AbstractStepMessage.AbstractStepMessage1](docs/components/schemas/AbstractStepMessage.md#abstractstepmessage1) | Abstract Step |
| [AdditionalPropertiesClass.AdditionalPropertiesClass1](docs/components/schemas/AdditionalPropertiesClass.md#additionalpropertiesclass1) | |
| [AdditionalPropertiesSchema.AdditionalPropertiesSchema1](docs/components/schemas/AdditionalPropertiesSchema.md#additionalpropertiesschema1) | |
| [AdditionalPropertiesWithArrayOfEnums.AdditionalPropertiesWithArrayOfEnums1](docs/components/schemas/AdditionalPropertiesWithArrayOfEnums.md#additionalpropertieswitharrayofenums1) | |
| [Address.Address1](docs/components/schemas/Address.md#address1) | |
| [Animal.Animal1](docs/components/schemas/Animal.md#animal1) | |
| [AnimalFarm.AnimalFarm1](docs/components/schemas/AnimalFarm.md#animalfarm1) | |
| [AnyTypeAndFormat.AnyTypeAndFormat1](docs/components/schemas/AnyTypeAndFormat.md#anytypeandformat1) | |
| [AnyTypeNotString.AnyTypeNotString1](docs/components/schemas/AnyTypeNotString.md#anytypenotstring1) | |
| [ApiResponseSchema.ApiResponseSchema1](docs/components/schemas/ApiResponseSchema.md#apiresponseschema1) | |
| [ArrayHoldingAnyType.ArrayHoldingAnyType1](docs/components/schemas/ArrayHoldingAnyType.md#arrayholdinganytype1) | |
| [ArrayOfArrayOfNumberOnly.ArrayOfArrayOfNumberOnly1](docs/components/schemas/ArrayOfArrayOfNumberOnly.md#arrayofarrayofnumberonly1) | |
| [ArrayOfEnums.ArrayOfEnums1](docs/components/schemas/ArrayOfEnums.md#arrayofenums1) | |
| [ArrayOfNumberOnly.ArrayOfNumberOnly1](docs/components/schemas/ArrayOfNumberOnly.md#arrayofnumberonly1) | |
| [ArrayTest.ArrayTest1](docs/components/schemas/ArrayTest.md#arraytest1) | |
| [ArrayWithValidationsInItems.ArrayWithValidationsInItems1](docs/components/schemas/ArrayWithValidationsInItems.md#arraywithvalidationsinitems1) | |
| [Bar.Bar1](docs/components/schemas/Bar.md#bar1) | |
| [BasquePig.BasquePig1](docs/components/schemas/BasquePig.md#basquepig1) | |
| [BooleanSchema.BooleanSchema1](docs/components/schemas/BooleanSchema.md#booleanschema1) | |
| [BooleanEnum.BooleanEnum1](docs/components/schemas/BooleanEnum.md#booleanenum1) | |
| [Capitalization.Capitalization1](docs/components/schemas/Capitalization.md#capitalization1) | |
| [Cat.Cat1](docs/components/schemas/Cat.md#cat1) | |
| [Category.Category1](docs/components/schemas/Category.md#category1) | |
| [ChildCat.ChildCat1](docs/components/schemas/ChildCat.md#childcat1) | |
| [ClassModel.ClassModel1](docs/components/schemas/ClassModel.md#classmodel1) | Model for testing model with &quot;_class&quot; property |
| [Client.Client1](docs/components/schemas/Client.md#client1) | |
| [ComplexQuadrilateral.ComplexQuadrilateral1](docs/components/schemas/ComplexQuadrilateral.md#complexquadrilateral1) | |
| [ComposedAnyOfDifferentTypesNoValidations.ComposedAnyOfDifferentTypesNoValidations1](docs/components/schemas/ComposedAnyOfDifferentTypesNoValidations.md#composedanyofdifferenttypesnovalidations1) | |
| [ComposedArray.ComposedArray1](docs/components/schemas/ComposedArray.md#composedarray1) | |
| [ComposedBool.ComposedBool1](docs/components/schemas/ComposedBool.md#composedbool1) | |
| [ComposedNone.ComposedNone1](docs/components/schemas/ComposedNone.md#composednone1) | |
| [ComposedNumber.ComposedNumber1](docs/components/schemas/ComposedNumber.md#composednumber1) | |
| [ComposedObject.ComposedObject1](docs/components/schemas/ComposedObject.md#composedobject1) | |
| [ComposedOneOfDifferentTypes.ComposedOneOfDifferentTypes1](docs/components/schemas/ComposedOneOfDifferentTypes.md#composedoneofdifferenttypes1) | this is a model that allows payloads of type object or number |
| [ComposedString.ComposedString1](docs/components/schemas/ComposedString.md#composedstring1) | |
| [Currency.Currency1](docs/components/schemas/Currency.md#currency1) | |
| [DanishPig.DanishPig1](docs/components/schemas/DanishPig.md#danishpig1) | |
| [DateTimeTest.DateTimeTest1](docs/components/schemas/DateTimeTest.md#datetimetest1) | |
| [DateTimeWithValidations.DateTimeWithValidations1](docs/components/schemas/DateTimeWithValidations.md#datetimewithvalidations1) | |
| [DateWithValidations.DateWithValidations1](docs/components/schemas/DateWithValidations.md#datewithvalidations1) | |
| [DecimalPayload.DecimalPayload1](docs/components/schemas/DecimalPayload.md#decimalpayload1) | |
| [Dog.Dog1](docs/components/schemas/Dog.md#dog1) | |
| [Drawing.Drawing1](docs/components/schemas/Drawing.md#drawing1) | |
| [EnumArrays.EnumArrays1](docs/components/schemas/EnumArrays.md#enumarrays1) | |
| [EnumClass.EnumClass1](docs/components/schemas/EnumClass.md#enumclass1) | |
| [EnumTest.EnumTest1](docs/components/schemas/EnumTest.md#enumtest1) | |
| [EquilateralTriangle.EquilateralTriangle1](docs/components/schemas/EquilateralTriangle.md#equilateraltriangle1) | |
| [File.File1](docs/components/schemas/File.md#file1) | Must be named &#x60;File&#x60; for test. |
| [FileSchemaTestClass.FileSchemaTestClass1](docs/components/schemas/FileSchemaTestClass.md#fileschematestclass1) | |
| [Foo.Foo1](docs/components/schemas/Foo.md#foo1) | |
| [FormatTest.FormatTest1](docs/components/schemas/FormatTest.md#formattest1) | |
| [FromSchema.FromSchema1](docs/components/schemas/FromSchema.md#fromschema1) | |
| [GrandparentAnimal.GrandparentAnimal1](docs/components/schemas/GrandparentAnimal.md#grandparentanimal1) | |
| [HealthCheckResult.HealthCheckResult1](docs/components/schemas/HealthCheckResult.md#healthcheckresult1) | Just a string to inform instance is up and running. Make it nullable in hope to get it as pointer in generated model. |
| [IntegerEnum.IntegerEnum1](docs/components/schemas/IntegerEnum.md#integerenum1) | |
| [IntegerEnumBig.IntegerEnumBig1](docs/components/schemas/IntegerEnumBig.md#integerenumbig1) | |
| [IntegerEnumOneValue.IntegerEnumOneValue1](docs/components/schemas/IntegerEnumOneValue.md#integerenumonevalue1) | |
| [IntegerEnumWithDefaultValue.IntegerEnumWithDefaultValue1](docs/components/schemas/IntegerEnumWithDefaultValue.md#integerenumwithdefaultvalue1) | |
| [IntegerMax10.IntegerMax101](docs/components/schemas/IntegerMax10.md#integermax101) | |
| [IntegerMin15.IntegerMin151](docs/components/schemas/IntegerMin15.md#integermin151) | |
| [IsoscelesTriangle.IsoscelesTriangle1](docs/components/schemas/IsoscelesTriangle.md#isoscelestriangle1) | |
| [Items.Items1](docs/components/schemas/Items.md#items1) | component&#x27;s name collides with the inner schema name |
| [ItemsSchema.ItemsSchema1](docs/components/schemas/ItemsSchema.md#itemsschema1) | |
| [JSONPatchRequest.JSONPatchRequest1](docs/components/schemas/JSONPatchRequest.md#jsonpatchrequest1) | |
| [JSONPatchRequestAddReplaceTest.JSONPatchRequestAddReplaceTest1](docs/components/schemas/JSONPatchRequestAddReplaceTest.md#jsonpatchrequestaddreplacetest1) | |
| [JSONPatchRequestMoveCopy.JSONPatchRequestMoveCopy1](docs/components/schemas/JSONPatchRequestMoveCopy.md#jsonpatchrequestmovecopy1) | |
| [JSONPatchRequestRemove.JSONPatchRequestRemove1](docs/components/schemas/JSONPatchRequestRemove.md#jsonpatchrequestremove1) | |
| [MapTest.MapTest1](docs/components/schemas/MapTest.md#maptest1) | |
| [MixedPropertiesAndAdditionalPropertiesClass.MixedPropertiesAndAdditionalPropertiesClass1](docs/components/schemas/MixedPropertiesAndAdditionalPropertiesClass.md#mixedpropertiesandadditionalpropertiesclass1) | |
| [Money.Money1](docs/components/schemas/Money.md#money1) | |
| [MultiPropertiesSchema.MultiPropertiesSchema1](docs/components/schemas/MultiPropertiesSchema.md#multipropertiesschema1) | |
| [MyObjectDto.MyObjectDto1](docs/components/schemas/MyObjectDto.md#myobjectdto1) | |
| [Name.Name1](docs/components/schemas/Name.md#name1) | Model for testing model name same as property name |
| [NoAdditionalProperties.NoAdditionalProperties1](docs/components/schemas/NoAdditionalProperties.md#noadditionalproperties1) | |
| [NullableClass.NullableClass1](docs/components/schemas/NullableClass.md#nullableclass1) | |
| [NullableShape.NullableShape1](docs/components/schemas/NullableShape.md#nullableshape1) | The value may be a shape or the &#x27;null&#x27; value. For a composed schema to validate a null payload, one of its chosen oneOf schemas must be type null or nullable (introduced in OAS schema &gt;&#x3D; 3.0) |
| [NullableString.NullableString1](docs/components/schemas/NullableString.md#nullablestring1) | |
| [NumberSchema.NumberSchema1](docs/components/schemas/NumberSchema.md#numberschema1) | |
| [NumberOnly.NumberOnly1](docs/components/schemas/NumberOnly.md#numberonly1) | |
| [NumberWithExclusiveMinMax.NumberWithExclusiveMinMax1](docs/components/schemas/NumberWithExclusiveMinMax.md#numberwithexclusiveminmax1) | |
| [NumberWithValidations.NumberWithValidations1](docs/components/schemas/NumberWithValidations.md#numberwithvalidations1) | |
| [ObjWithRequiredProps.ObjWithRequiredProps1](docs/components/schemas/ObjWithRequiredProps.md#objwithrequiredprops1) | |
| [ObjWithRequiredPropsBase.ObjWithRequiredPropsBase1](docs/components/schemas/ObjWithRequiredPropsBase.md#objwithrequiredpropsbase1) | |
| [ObjectInterface.ObjectInterface1](docs/components/schemas/ObjectInterface.md#objectinterface1) | |
| [ObjectModelWithArgAndArgsProperties.ObjectModelWithArgAndArgsProperties1](docs/components/schemas/ObjectModelWithArgAndArgsProperties.md#objectmodelwithargandargsproperties1) | |
| [ObjectModelWithRefProps.ObjectModelWithRefProps1](docs/components/schemas/ObjectModelWithRefProps.md#objectmodelwithrefprops1) | a model that includes properties which should stay primitive (String + Boolean) and one which is defined as a class, NumberWithValidations |
| [ObjectWithAllOfWithReqTestPropFromUnsetAddProp.ObjectWithAllOfWithReqTestPropFromUnsetAddProp1](docs/components/schemas/ObjectWithAllOfWithReqTestPropFromUnsetAddProp.md#objectwithallofwithreqtestpropfromunsetaddprop1) | |
| [ObjectWithCollidingProperties.ObjectWithCollidingProperties1](docs/components/schemas/ObjectWithCollidingProperties.md#objectwithcollidingproperties1) | component with properties that have name collisions |
| [ObjectWithDecimalProperties.ObjectWithDecimalProperties1](docs/components/schemas/ObjectWithDecimalProperties.md#objectwithdecimalproperties1) | |
| [ObjectWithDifficultlyNamedProps.ObjectWithDifficultlyNamedProps1](docs/components/schemas/ObjectWithDifficultlyNamedProps.md#objectwithdifficultlynamedprops1) | model with properties that have invalid names for python |
| [ObjectWithInlineCompositionProperty.ObjectWithInlineCompositionProperty1](docs/components/schemas/ObjectWithInlineCompositionProperty.md#objectwithinlinecompositionproperty1) | |
| [ObjectWithInvalidNamedRefedProperties.ObjectWithInvalidNamedRefedProperties1](docs/components/schemas/ObjectWithInvalidNamedRefedProperties.md#objectwithinvalidnamedrefedproperties1) | |
| [ObjectWithNonIntersectingValues.ObjectWithNonIntersectingValues1](docs/components/schemas/ObjectWithNonIntersectingValues.md#objectwithnonintersectingvalues1) | |
| [ObjectWithOnlyOptionalProps.ObjectWithOnlyOptionalProps1](docs/components/schemas/ObjectWithOnlyOptionalProps.md#objectwithonlyoptionalprops1) | |
| [ObjectWithOptionalTestProp.ObjectWithOptionalTestProp1](docs/components/schemas/ObjectWithOptionalTestProp.md#objectwithoptionaltestprop1) | |
| [ObjectWithValidations.ObjectWithValidations1](docs/components/schemas/ObjectWithValidations.md#objectwithvalidations1) | |
| [Order.Order1](docs/components/schemas/Order.md#order1) | |
| [PaginatedResultMyObjectDto.PaginatedResultMyObjectDto1](docs/components/schemas/PaginatedResultMyObjectDto.md#paginatedresultmyobjectdto1) | |
| [ParentPet.ParentPet1](docs/components/schemas/ParentPet.md#parentpet1) | |
| [Pet.Pet1](docs/components/schemas/Pet.md#pet1) | Pet object that needs to be added to the store |
| [Pig.Pig1](docs/components/schemas/Pig.md#pig1) | |
| [Player.Player1](docs/components/schemas/Player.md#player1) | a model that includes a self reference this forces properties and additionalProperties to be lazy loaded in python models because the Player class has not fully loaded when defining properties |
| [PublicKey.PublicKey1](docs/components/schemas/PublicKey.md#publickey1) | schema that contains a property named key |
| [Quadrilateral.Quadrilateral1](docs/components/schemas/Quadrilateral.md#quadrilateral1) | |
| [QuadrilateralInterface.QuadrilateralInterface1](docs/components/schemas/QuadrilateralInterface.md#quadrilateralinterface1) | |
| [ReadOnlyFirst.ReadOnlyFirst1](docs/components/schemas/ReadOnlyFirst.md#readonlyfirst1) | |
| [RefPet.RefPet1](docs/components/schemas/RefPet.md#refpet1) | |
| [ReqPropsFromExplicitAddProps.ReqPropsFromExplicitAddProps1](docs/components/schemas/ReqPropsFromExplicitAddProps.md#reqpropsfromexplicitaddprops1) | |
| [ReqPropsFromTrueAddProps.ReqPropsFromTrueAddProps1](docs/components/schemas/ReqPropsFromTrueAddProps.md#reqpropsfromtrueaddprops1) | |
| [ReqPropsFromUnsetAddProps.ReqPropsFromUnsetAddProps1](docs/components/schemas/ReqPropsFromUnsetAddProps.md#reqpropsfromunsetaddprops1) | |
| [ReturnSchema.ReturnSchema1](docs/components/schemas/ReturnSchema.md#returnschema1) | Model for testing reserved words |
| [ScaleneTriangle.ScaleneTriangle1](docs/components/schemas/ScaleneTriangle.md#scalenetriangle1) | |
| [SelfReferencingArrayModel.SelfReferencingArrayModel1](docs/components/schemas/SelfReferencingArrayModel.md#selfreferencingarraymodel1) | |
| [SelfReferencingObjectModel.SelfReferencingObjectModel1](docs/components/schemas/SelfReferencingObjectModel.md#selfreferencingobjectmodel1) | |
| [Shape.Shape1](docs/components/schemas/Shape.md#shape1) | |
| [ShapeOrNull.ShapeOrNull1](docs/components/schemas/ShapeOrNull.md#shapeornull1) | The value may be a shape or the &#x27;null&#x27; value. This is introduced in OAS schema &gt;&#x3D; 3.1. |
| [SimpleQuadrilateral.SimpleQuadrilateral1](docs/components/schemas/SimpleQuadrilateral.md#simplequadrilateral1) | |
| [SomeObject.SomeObject1](docs/components/schemas/SomeObject.md#someobject1) | |
| [StringSchema.StringSchema1](docs/components/schemas/StringSchema.md#stringschema1) | |
| [StringBooleanMap.StringBooleanMap1](docs/components/schemas/StringBooleanMap.md#stringbooleanmap1) | |
| [StringEnum.StringEnum1](docs/components/schemas/StringEnum.md#stringenum1) | |
| [StringEnumWithDefaultValue.StringEnumWithDefaultValue1](docs/components/schemas/StringEnumWithDefaultValue.md#stringenumwithdefaultvalue1) | |
| [StringWithValidation.StringWithValidation1](docs/components/schemas/StringWithValidation.md#stringwithvalidation1) | |
| [Tag.Tag1](docs/components/schemas/Tag.md#tag1) | |
| [Triangle.Triangle1](docs/components/schemas/Triangle.md#triangle1) | |
| [TriangleInterface.TriangleInterface1](docs/components/schemas/TriangleInterface.md#triangleinterface1) | |
| [UUIDString.UUIDString1](docs/components/schemas/UUIDString.md#uuidstring1) | |
| [User.User1](docs/components/schemas/User.md#user1) | |
| [SpecialModelname.SpecialModelname1](docs/components/schemas/SpecialModelname.md#specialmodelname1) | model with an invalid class name for python |
| [Apple.Apple1](docs/components/schemas/Apple.md#apple1) | |
| [AppleReq.AppleReq1](docs/components/schemas/AppleReq.md#applereq1) | |
| [Banana.Banana1](docs/components/schemas/Banana.md#banana1) | |
| [BananaReq.BananaReq1](docs/components/schemas/BananaReq.md#bananareq1) | |
| [Fruit.Fruit1](docs/components/schemas/Fruit.md#fruit1) | |
| [FruitReq.FruitReq1](docs/components/schemas/FruitReq.md#fruitreq1) | |
| [GmFruit.GmFruit1](docs/components/schemas/GmFruit.md#gmfruit1) | |
| [HasOnlyReadOnly.HasOnlyReadOnly1](docs/components/schemas/HasOnlyReadOnly.md#hasonlyreadonly1) | |
| [Mammal.Mammal1](docs/components/schemas/Mammal.md#mammal1) | |
| [Whale.Whale1](docs/components/schemas/Whale.md#whale1) | |
| [Zebra.Zebra1](docs/components/schemas/Zebra.md#zebra1) | |

## Component RequestBodies
| Class | Description |
| ----- | ----------- |
| [Client.Client1](docs/components/requestbodies/Client.md#client1) | client model |
| [Pet.Pet1](docs/components/requestbodies/Pet.md#pet1) | Pet object that needs to be added to the store, multiple content types |
| [RefUserArray.RefUserArray1](docs/components/requestbodies/RefUserArray.md#refuserarray1) | |
| [UserArray.UserArray1](docs/components/requestbodies/UserArray.md#userarray1) | List of user object |

## Component Responses
| Class | Description |
| ----- | ----------- |
| [HeadersWithNoBody.HeadersWithNoBody1](docs/components/responses/HeadersWithNoBody.md#headerswithnobody1) | A response that contains headers but no body<br>|
| [RefSuccessDescriptionOnly.RefSuccessDescriptionOnly1](docs/components/responses/RefSuccessDescriptionOnly.md#refsuccessdescriptiononly1) ||
| [RefSuccessfulXmlAndJsonArrayOfPet.RefSuccessfulXmlAndJsonArrayOfPet1](docs/components/responses/RefSuccessfulXmlAndJsonArrayOfPet.md#refsuccessfulxmlandjsonarrayofpet1) ||
| [SuccessDescriptionOnly.SuccessDescriptionOnly1](docs/components/responses/SuccessDescriptionOnly.md#successdescriptiononly1) | Success|
| [SuccessInlineContentAndHeader.SuccessInlineContentAndHeader1](docs/components/responses/SuccessInlineContentAndHeader.md#successinlinecontentandheader1) | successful operation|
| [SuccessWithJsonApiResponse.SuccessWithJsonApiResponse1](docs/components/responses/SuccessWithJsonApiResponse.md#successwithjsonapiresponse1) | successful operation|
| [SuccessfulXmlAndJsonArrayOfPet.SuccessfulXmlAndJsonArrayOfPet1](docs/components/responses/SuccessfulXmlAndJsonArrayOfPet.md#successfulxmlandjsonarrayofpet1) | successful operation, multiple content types|

## Component Headers
| Class | Description |
| ----- | ----------- |
| [Int32JsonContentTypeHeader.Int32JsonContentTypeHeader1](docs/components/headers/Int32JsonContentTypeHeader.md#int32jsoncontenttypeheader1) | int32 JSON content-type header |
| [NumberHeader.NumberHeader1](docs/components/headers/NumberHeader.md#numberheader1) | number header description |
| [RefContentSchemaHeader.RefContentSchemaHeader1](docs/components/headers/RefContentSchemaHeader.md#refcontentschemaheader1) | int32 JSON content-type header |
| [RefSchemaHeader.RefSchemaHeader1](docs/components/headers/RefSchemaHeader.md#refschemaheader1) | header that has a ref in the schema |
| [RefStringHeader.RefStringHeader1](docs/components/headers/RefStringHeader.md#refstringheader1) | |
| [StringHeader.StringHeader1](docs/components/headers/StringHeader.md#stringheader1) | string header description |

## Component Parameters
| Class | Description |
| ----- | ----------- |
| [ComponentRefSchemaStringWithValidation.ComponentRefSchemaStringWithValidation1](docs/components/parameters/ComponentRefSchemaStringWithValidation.md#componentrefschemastringwithvalidation1) | a path string with validation |
| [PathUserName.PathUserName1](docs/components/parameters/PathUserName.md#pathusername1) | the use name to use |
| [RefPathUserName.RefPathUserName1](docs/components/parameters/RefPathUserName.md#refpathusername1) | |
| [RefSchemaStringWithValidation.RefSchemaStringWithValidation1](docs/components/parameters/RefSchemaStringWithValidation.md#refschemastringwithvalidation1) | a path string with validation |
