# coding: utf-8

"""


    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest
from unittest.mock import patch

import urllib3

import this_package
from this_package.paths.path_with_security_from_root.get import operation as get  # noqa: E501
from this_package import schemas, api_client
from this_package.configurations import api_configuration, schema_configuration
from this_package.components.security_schemes import security_scheme_api_key
from this_package.components.security_schemes import security_scheme_http_basic_test
from this_package.components.security_schemes import security_scheme_http_basic_test
from this_package.components.security_schemes import security_scheme_api_key

from .. import ApiTestMixin


class TestGet(ApiTestMixin, unittest.TestCase):
    """
    Get unit test stubs
        path with security from root  # noqa: E501
    """
    security_scheme_info: api_configuration.SecuritySchemeInfo = {
        # security_scheme_info for security_index 0 + 3
        "api_key": security_scheme_api_key.ApiKey(
            api_key='sampleApiKeyValue'
        ),
        # security_scheme_info for security_index 1 + 3
        "http_basic_test": security_scheme_http_basic_test.HttpBasicTest(
            user_id='someUserIdOrName',
            password='somePassword',
        ),
    }

    api_config = api_configuration.ApiConfiguration(
        security_scheme_info=security_scheme_info
    )
    schema_config = schema_configuration.SchemaConfiguration()
    used_api_client = api_client.ApiClient(configuration=api_config, schema_configuration=schema_config)
    api = get.ApiForGet(api_client=used_api_client)  # noqa: E501

    @patch.object(urllib3.PoolManager, 'request')
    def test_endpoint_call_contains_security0(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        api_response = api.get()
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://localhost:3000/pathWithSecurityFromRoot',
            method='GET',
            additional_headers={'api_key': 'sampleApiKeyValue'}
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200

    @patch.object(urllib3.PoolManager, 'request')
    def test_endpoint_call_contains_security1(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        api_response = api.get(security_index=1)
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://localhost:3000/pathWithSecurityFromRoot',
            method='GET',
            additional_headers={'Authorization': 'Basic c29tZVVzZXJJZE9yTmFtZTpzb21lUGFzc3dvcmQ='}
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200

    @patch.object(urllib3.PoolManager, 'request')
    def test_endpoint_call_contains_security2(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        api_response = api.get(security_index=2)
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://localhost:3000/pathWithSecurityFromRoot',
            method='GET',
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200

    @patch.object(urllib3.PoolManager, 'request')
    def test_endpoint_call_contains_security3(self, mock_request):
        mock_request.return_value = self.response(b'')

        api = get.ApiForGet(api_client=self.used_api_client)
        api_response = api.get(security_index=3)
        self.assert_pool_manager_request_called_with(
            mock_request,
            f'http://localhost:3000/pathWithSecurityFromRoot',
            method='GET',
            additional_headers={
                'Authorization': 'Basic c29tZVVzZXJJZE9yTmFtZTpzb21lUGFzc3dvcmQ=',
                'api_key': 'sampleApiKeyValue'
            }
        )

        assert isinstance(api_response.response, urllib3.HTTPResponse)
        assert isinstance(api_response.body, schemas.Unset)
        assert isinstance(api_response.headers, schemas.Unset)
        assert api_response.response.status == 200


if __name__ == '__main__':
    unittest.main()
