# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.unevaluatedproperties_schema import UnevaluatedpropertiesSchema
from unit_test_api.configurations import schema_configuration


class TestUnevaluatedpropertiesSchema(unittest.TestCase):
    """UnevaluatedpropertiesSchema unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_with_no_unevaluated_properties_passes(self):
        # with no unevaluated properties
        UnevaluatedpropertiesSchema.validate(
            {
            },
            configuration=self.configuration
        )

    def test_with_invalid_unevaluated_properties_fails(self):
        # with invalid unevaluated properties
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            UnevaluatedpropertiesSchema.validate(
                {
                    "foo":
                        "fo",
                },
                configuration=self.configuration
            )

    def test_with_valid_unevaluated_properties_passes(self):
        # with valid unevaluated properties
        UnevaluatedpropertiesSchema.validate(
            {
                "foo":
                    "foo",
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
