# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.unevaluateditems_as_schema import UnevaluateditemsAsSchema
from unit_test_api.configurations import schema_configuration


class TestUnevaluateditemsAsSchema(unittest.TestCase):
    """UnevaluateditemsAsSchema unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_with_invalid_unevaluated_items_fails(self):
        # with invalid unevaluated items
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            UnevaluateditemsAsSchema.validate(
                [
                    42,
                ],
                configuration=self.configuration
            )

    def test_with_no_unevaluated_items_passes(self):
        # with no unevaluated items
        UnevaluateditemsAsSchema.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_with_valid_unevaluated_items_passes(self):
        # with valid unevaluated items
        UnevaluateditemsAsSchema.validate(
            [
                "foo",
            ],
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
