# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.single_dependency import SingleDependency
from unit_test_api.configurations import schema_configuration


class TestSingleDependency(unittest.TestCase):
    """SingleDependency unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_nondependant_passes(self):
        # nondependant
        SingleDependency.validate(
            {
                "foo":
                    1,
            },
            configuration=self.configuration
        )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        SingleDependency.validate(
            [
                "bar",
            ],
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        SingleDependency.validate(
            12,
            configuration=self.configuration
        )

    def test_neither_passes(self):
        # neither
        SingleDependency.validate(
            {
            },
            configuration=self.configuration
        )

    def test_ignores_strings_passes(self):
        # ignores strings
        SingleDependency.validate(
            "foobar",
            configuration=self.configuration
        )

    def test_with_dependency_passes(self):
        # with dependency
        SingleDependency.validate(
            {
                "foo":
                    1,
                "bar":
                    2,
            },
            configuration=self.configuration
        )

    def test_missing_dependency_fails(self):
        # missing dependency
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            SingleDependency.validate(
                {
                    "bar":
                        2,
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
