# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.required_with_escaped_characters import RequiredWithEscapedCharacters
from unit_test_api.configurations import schema_configuration


class TestRequiredWithEscapedCharacters(unittest.TestCase):
    """RequiredWithEscapedCharacters unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_object_with_some_properties_missing_is_invalid_fails(self):
        # object with some properties missing is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            RequiredWithEscapedCharacters.validate(
                {
                    "foo\nbar":
                        "1",
                    "foo\"bar":
                        "1",
                },
                configuration=self.configuration
            )

    def test_object_with_all_properties_present_is_valid_passes(self):
        # object with all properties present is valid
        RequiredWithEscapedCharacters.validate(
            {
                "foo\nbar":
                    1,
                "foo\"bar":
                    1,
                "foo\\bar":
                    1,
                "foo\rbar":
                    1,
                "foo\tbar":
                    1,
                "foo\fbar":
                    1,
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
