# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.required_properties_whose_names_are_javascript_object_property_names import RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames
from unit_test_api.configurations import schema_configuration


class TestRequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames(unittest.TestCase):
    """RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_constructor_present_fails(self):
        # constructor present
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
                {
                    "constructor":
                        {
                            "length":
                                37,
                        },
                },
                configuration=self.configuration
            )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_all_present_passes(self):
        # all present
        RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
            {
                "__proto__":
                    12,
                "toString":
                    {
                        "length":
                            "foo",
                    },
                "constructor":
                    37,
            },
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
            12,
            configuration=self.configuration
        )

    def test_proto_present_fails(self):
        # __proto__ present
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
                {
                    "__proto__":
                        "foo",
                },
                configuration=self.configuration
            )

    def test_none_of_the_properties_mentioned_fails(self):
        # none of the properties mentioned
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
                {
                },
                configuration=self.configuration
            )

    def test_tostring_present_fails(self):
        # toString present
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            RequiredPropertiesWhoseNamesAreJavascriptObjectPropertyNames.validate(
                {
                    "toString":
                        {
                            "length":
                                37,
                        },
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
