# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.propertynames_validation import PropertynamesValidation
from unit_test_api.configurations import schema_configuration


class TestPropertynamesValidation(unittest.TestCase):
    """PropertynamesValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_some_property_names_invalid_fails(self):
        # some property names invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            PropertynamesValidation.validate(
                {
                    "foo":
                        {
                        },
                    "foobar":
                        {
                        },
                },
                configuration=self.configuration
            )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        PropertynamesValidation.validate(
            [
                1,
                2,
                3,
                4,
            ],
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        PropertynamesValidation.validate(
            12,
            configuration=self.configuration
        )

    def test_ignores_strings_passes(self):
        # ignores strings
        PropertynamesValidation.validate(
            "foobar",
            configuration=self.configuration
        )

    def test_object_without_properties_is_valid_passes(self):
        # object without properties is valid
        PropertynamesValidation.validate(
            {
            },
            configuration=self.configuration
        )

    def test_all_property_names_valid_passes(self):
        # all property names valid
        PropertynamesValidation.validate(
            {
                "f":
                    {
                    },
                "foo":
                    {
                    },
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
