# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.properties_with_escaped_characters import PropertiesWithEscapedCharacters
from unit_test_api.configurations import schema_configuration


class TestPropertiesWithEscapedCharacters(unittest.TestCase):
    """PropertiesWithEscapedCharacters unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_object_with_all_numbers_is_valid_passes(self):
        # object with all numbers is valid
        PropertiesWithEscapedCharacters.validate(
            {
                "foo\nbar":
                    1,
                "foo\"bar":
                    1,
                "foo\\bar":
                    1,
                "foo\rbar":
                    1,
                "foo\tbar":
                    1,
                "foo\fbar":
                    1,
            },
            configuration=self.configuration
        )

    def test_object_with_strings_is_invalid_fails(self):
        # object with strings is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            PropertiesWithEscapedCharacters.validate(
                {
                    "foo\nbar":
                        "1",
                    "foo\"bar":
                        "1",
                    "foo\\bar":
                        "1",
                    "foo\rbar":
                        "1",
                    "foo\tbar":
                        "1",
                    "foo\fbar":
                        "1",
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
