# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.patternproperties_validates_properties_matching_a_regex import PatternpropertiesValidatesPropertiesMatchingARegex
from unit_test_api.configurations import schema_configuration


class TestPatternpropertiesValidatesPropertiesMatchingARegex(unittest.TestCase):
    """PatternpropertiesValidatesPropertiesMatchingARegex unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_a_single_valid_match_is_valid_passes(self):
        # a single valid match is valid
        PatternpropertiesValidatesPropertiesMatchingARegex.validate(
            {
                "foo":
                    1,
            },
            configuration=self.configuration
        )

    def test_multiple_valid_matches_is_valid_passes(self):
        # multiple valid matches is valid
        PatternpropertiesValidatesPropertiesMatchingARegex.validate(
            {
                "foo":
                    1,
                "foooooo":
                    2,
            },
            configuration=self.configuration
        )

    def test_multiple_invalid_matches_is_invalid_fails(self):
        # multiple invalid matches is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            PatternpropertiesValidatesPropertiesMatchingARegex.validate(
                {
                    "foo":
                        "bar",
                    "foooooo":
                        "baz",
                },
                configuration=self.configuration
            )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        PatternpropertiesValidatesPropertiesMatchingARegex.validate(
            [
                "foo",
            ],
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        PatternpropertiesValidatesPropertiesMatchingARegex.validate(
            12,
            configuration=self.configuration
        )

    def test_ignores_strings_passes(self):
        # ignores strings
        PatternpropertiesValidatesPropertiesMatchingARegex.validate(
            "foo",
            configuration=self.configuration
        )

    def test_a_single_invalid_match_is_invalid_fails(self):
        # a single invalid match is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            PatternpropertiesValidatesPropertiesMatchingARegex.validate(
                {
                    "foo":
                        "bar",
                    "fooooo":
                        2,
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
