# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.pattern_validation import PatternValidation
from unit_test_api.configurations import schema_configuration


class TestPatternValidation(unittest.TestCase):
    """PatternValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        PatternValidation.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_ignores_objects_passes(self):
        # ignores objects
        PatternValidation.validate(
            {
            },
            configuration=self.configuration
        )

    def test_ignores_null_passes(self):
        # ignores null
        PatternValidation.validate(
            None,
            configuration=self.configuration
        )

    def test_ignores_floats_passes(self):
        # ignores floats
        PatternValidation.validate(
            1.0,
            configuration=self.configuration
        )

    def test_a_non_matching_pattern_is_invalid_fails(self):
        # a non-matching pattern is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            PatternValidation.validate(
                "abc",
                configuration=self.configuration
            )

    def test_ignores_booleans_passes(self):
        # ignores booleans
        PatternValidation.validate(
            True,
            configuration=self.configuration
        )

    def test_a_matching_pattern_is_valid_passes(self):
        # a matching pattern is valid
        PatternValidation.validate(
            "aaa",
            configuration=self.configuration
        )

    def test_ignores_integers_passes(self):
        # ignores integers
        PatternValidation.validate(
            123,
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
