# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.multiple_simultaneous_patternproperties_are_validated import MultipleSimultaneousPatternpropertiesAreValidated
from unit_test_api.configurations import schema_configuration


class TestMultipleSimultaneousPatternpropertiesAreValidated(unittest.TestCase):
    """MultipleSimultaneousPatternpropertiesAreValidated unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_multiple_matches_is_valid_passes(self):
        # multiple matches is valid
        MultipleSimultaneousPatternpropertiesAreValidated.validate(
            {
                "a":
                    21,
                "aaaa":
                    18,
            },
            configuration=self.configuration
        )

    def test_an_invalid_due_to_the_other_is_invalid_fails(self):
        # an invalid due to the other is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MultipleSimultaneousPatternpropertiesAreValidated.validate(
                {
                    "aaaa":
                        31,
                },
                configuration=self.configuration
            )

    def test_an_invalid_due_to_both_is_invalid_fails(self):
        # an invalid due to both is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MultipleSimultaneousPatternpropertiesAreValidated.validate(
                {
                    "aaa":
                        "foo",
                    "aaaa":
                        31,
                },
                configuration=self.configuration
            )

    def test_a_single_valid_match_is_valid_passes(self):
        # a single valid match is valid
        MultipleSimultaneousPatternpropertiesAreValidated.validate(
            {
                "a":
                    21,
            },
            configuration=self.configuration
        )

    def test_a_simultaneous_match_is_valid_passes(self):
        # a simultaneous match is valid
        MultipleSimultaneousPatternpropertiesAreValidated.validate(
            {
                "aaaa":
                    18,
            },
            configuration=self.configuration
        )

    def test_an_invalid_due_to_one_is_invalid_fails(self):
        # an invalid due to one is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MultipleSimultaneousPatternpropertiesAreValidated.validate(
                {
                    "a":
                        "bar",
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
