# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.minimum_validation import MinimumValidation
from unit_test_api.configurations import schema_configuration


class TestMinimumValidation(unittest.TestCase):
    """MinimumValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_boundary_point_is_valid_passes(self):
        # boundary point is valid
        MinimumValidation.validate(
            1.1,
            configuration=self.configuration
        )

    def test_below_the_minimum_is_invalid_fails(self):
        # below the minimum is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MinimumValidation.validate(
                0.6,
                configuration=self.configuration
            )

    def test_above_the_minimum_is_valid_passes(self):
        # above the minimum is valid
        MinimumValidation.validate(
            2.6,
            configuration=self.configuration
        )

    def test_ignores_non_numbers_passes(self):
        # ignores non-numbers
        MinimumValidation.validate(
            "x",
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
