# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.maxproperties_validation import MaxpropertiesValidation
from unit_test_api.configurations import schema_configuration


class TestMaxpropertiesValidation(unittest.TestCase):
    """MaxpropertiesValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_too_long_is_invalid_fails(self):
        # too long is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MaxpropertiesValidation.validate(
                {
                    "foo":
                        1,
                    "bar":
                        2,
                    "baz":
                        3,
                },
                configuration=self.configuration
            )

    def test_ignores_arrays_passes(self):
        # ignores arrays
        MaxpropertiesValidation.validate(
            [
                1,
                2,
                3,
            ],
            configuration=self.configuration
        )

    def test_ignores_other_non_objects_passes(self):
        # ignores other non-objects
        MaxpropertiesValidation.validate(
            12,
            configuration=self.configuration
        )

    def test_ignores_strings_passes(self):
        # ignores strings
        MaxpropertiesValidation.validate(
            "foobar",
            configuration=self.configuration
        )

    def test_shorter_is_valid_passes(self):
        # shorter is valid
        MaxpropertiesValidation.validate(
            {
                "foo":
                    1,
            },
            configuration=self.configuration
        )

    def test_exact_length_is_valid_passes(self):
        # exact length is valid
        MaxpropertiesValidation.validate(
            {
                "foo":
                    1,
                "bar":
                    2,
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
