# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.maxlength_validation import MaxlengthValidation
from unit_test_api.configurations import schema_configuration


class TestMaxlengthValidation(unittest.TestCase):
    """MaxlengthValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_too_long_is_invalid_fails(self):
        # too long is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            MaxlengthValidation.validate(
                "foo",
                configuration=self.configuration
            )

    def test_ignores_non_strings_passes(self):
        # ignores non-strings
        MaxlengthValidation.validate(
            100,
            configuration=self.configuration
        )

    def test_shorter_is_valid_passes(self):
        # shorter is valid
        MaxlengthValidation.validate(
            "f",
            configuration=self.configuration
        )

    def test_two_supplementary_unicode_code_points_is_long_enough_passes(self):
        # two supplementary Unicode code points is long enough
        MaxlengthValidation.validate(
            "💩💩",
            configuration=self.configuration
        )

    def test_exact_length_is_valid_passes(self):
        # exact length is valid
        MaxlengthValidation.validate(
            "fo",
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
