# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.items_contains import ItemsContains
from unit_test_api.configurations import schema_configuration


class TestItemsContains(unittest.TestCase):
    """ItemsContains unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_does_not_match_items_matches_contains_fails(self):
        # does not match items, matches contains
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ItemsContains.validate(
                [
                    3,
                    6,
                    9,
                ],
                configuration=self.configuration
            )

    def test_matches_neither_items_nor_contains_fails(self):
        # matches neither items nor contains
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ItemsContains.validate(
                [
                    1,
                    5,
                ],
                configuration=self.configuration
            )

    def test_matches_items_does_not_match_contains_fails(self):
        # matches items, does not match contains
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ItemsContains.validate(
                [
                    2,
                    4,
                    8,
                ],
                configuration=self.configuration
            )

    def test_matches_both_items_and_contains_passes(self):
        # matches both items and contains
        ItemsContains.validate(
            [
                6,
                12,
            ],
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
