# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.forbidden_property import ForbiddenProperty
from unit_test_api.configurations import schema_configuration


class TestForbiddenProperty(unittest.TestCase):
    """ForbiddenProperty unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_property_present_fails(self):
        # property present
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ForbiddenProperty.validate(
                {
                    "foo":
                        1,
                    "bar":
                        2,
                },
                configuration=self.configuration
            )

    def test_property_absent_passes(self):
        # property absent
        ForbiddenProperty.validate(
            {
                "bar":
                    1,
                "baz":
                    2,
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
