# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.exclusivemaximum_validation import ExclusivemaximumValidation
from unit_test_api.configurations import schema_configuration


class TestExclusivemaximumValidation(unittest.TestCase):
    """ExclusivemaximumValidation unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_above_the_exclusivemaximum_is_invalid_fails(self):
        # above the exclusiveMaximum is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ExclusivemaximumValidation.validate(
                3.5,
                configuration=self.configuration
            )

    def test_below_the_exclusivemaximum_is_valid_passes(self):
        # below the exclusiveMaximum is valid
        ExclusivemaximumValidation.validate(
            2.2,
            configuration=self.configuration
        )

    def test_boundary_point_is_invalid_fails(self):
        # boundary point is invalid
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ExclusivemaximumValidation.validate(
                3.0,
                configuration=self.configuration
            )

    def test_ignores_non_numbers_passes(self):
        # ignores non-numbers
        ExclusivemaximumValidation.validate(
            "x",
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
