# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.dependent_schemas_dependent_subschema_incompatible_with_root import DependentSchemasDependentSubschemaIncompatibleWithRoot
from unit_test_api.configurations import schema_configuration


class TestDependentSchemasDependentSubschemaIncompatibleWithRoot(unittest.TestCase):
    """DependentSchemasDependentSubschemaIncompatibleWithRoot unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_matches_both_fails(self):
        # matches both
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            DependentSchemasDependentSubschemaIncompatibleWithRoot.validate(
                {
                    "foo":
                        1,
                    "bar":
                        2,
                },
                configuration=self.configuration
            )

    def test_matches_dependency_passes(self):
        # matches dependency
        DependentSchemasDependentSubschemaIncompatibleWithRoot.validate(
            {
                "bar":
                    1,
            },
            configuration=self.configuration
        )

    def test_matches_root_fails(self):
        # matches root
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            DependentSchemasDependentSubschemaIncompatibleWithRoot.validate(
                {
                    "foo":
                        1,
                },
                configuration=self.configuration
            )

    def test_no_dependency_passes(self):
        # no dependency
        DependentSchemasDependentSubschemaIncompatibleWithRoot.validate(
            {
                "baz":
                    1,
            },
            configuration=self.configuration
        )


if __name__ == '__main__':
    unittest.main()
