# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.dependent_schemas_dependencies_with_escaped_characters import DependentSchemasDependenciesWithEscapedCharacters
from unit_test_api.configurations import schema_configuration


class TestDependentSchemasDependenciesWithEscapedCharacters(unittest.TestCase):
    """DependentSchemasDependenciesWithEscapedCharacters unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_quoted_tab_passes(self):
        # quoted tab
        DependentSchemasDependenciesWithEscapedCharacters.validate(
            {
                "foo\tbar":
                    1,
                "a":
                    2,
                "b":
                    3,
                "c":
                    4,
            },
            configuration=self.configuration
        )

    def test_quoted_quote_invalid_under_dependent_schema_fails(self):
        # quoted quote invalid under dependent schema
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            DependentSchemasDependenciesWithEscapedCharacters.validate(
                {
                    "foo'bar":
                        1,
                },
                configuration=self.configuration
            )

    def test_quoted_quote_fails(self):
        # quoted quote
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            DependentSchemasDependenciesWithEscapedCharacters.validate(
                {
                    "foo'bar":
                        {
                            "foo\"bar":
                                1,
                        },
                },
                configuration=self.configuration
            )

    def test_quoted_tab_invalid_under_dependent_schema_fails(self):
        # quoted tab invalid under dependent schema
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            DependentSchemasDependenciesWithEscapedCharacters.validate(
                {
                    "foo\tbar":
                        1,
                    "a":
                        2,
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
