# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.const_nul_characters_in_strings import ConstNulCharactersInStrings
from unit_test_api.configurations import schema_configuration


class TestConstNulCharactersInStrings(unittest.TestCase):
    """ConstNulCharactersInStrings unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_match_string_with_nul_passes(self):
        # match string with nul
        ConstNulCharactersInStrings.validate(
            "hello\x00there",
            configuration=self.configuration
        )

    def test_do_not_match_string_lacking_nul_fails(self):
        # do not match string lacking nul
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ConstNulCharactersInStrings.validate(
                "hellothere",
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
