# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.allof_with_base_schema import AllofWithBaseSchema
from unit_test_api.configurations import schema_configuration


class TestAllofWithBaseSchema(unittest.TestCase):
    """AllofWithBaseSchema unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_valid_passes(self):
        # valid
        AllofWithBaseSchema.validate(
            {
                "foo":
                    "quux",
                "bar":
                    2,
                "baz":
                    None,
            },
            configuration=self.configuration
        )

    def test_mismatch_first_allof_fails(self):
        # mismatch first allOf
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofWithBaseSchema.validate(
                {
                    "bar":
                        2,
                    "baz":
                        None,
                },
                configuration=self.configuration
            )

    def test_mismatch_base_schema_fails(self):
        # mismatch base schema
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofWithBaseSchema.validate(
                {
                    "foo":
                        "quux",
                    "baz":
                        None,
                },
                configuration=self.configuration
            )

    def test_mismatch_both_fails(self):
        # mismatch both
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofWithBaseSchema.validate(
                {
                    "bar":
                        2,
                },
                configuration=self.configuration
            )

    def test_mismatch_second_allof_fails(self):
        # mismatch second allOf
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            AllofWithBaseSchema.validate(
                {
                    "foo":
                        "quux",
                    "bar":
                        2,
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
