# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.allof import Allof
from unit_test_api.configurations import schema_configuration


class TestAllof(unittest.TestCase):
    """Allof unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_allof_passes(self):
        # allOf
        Allof.validate(
            {
                "foo":
                    "baz",
                "bar":
                    2,
            },
            configuration=self.configuration
        )

    def test_mismatch_first_fails(self):
        # mismatch first
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            Allof.validate(
                {
                    "bar":
                        2,
                },
                configuration=self.configuration
            )

    def test_mismatch_second_fails(self):
        # mismatch second
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            Allof.validate(
                {
                    "foo":
                        "baz",
                },
                configuration=self.configuration
            )

    def test_wrong_type_fails(self):
        # wrong type
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            Allof.validate(
                {
                    "foo":
                        "baz",
                    "bar":
                        "quux",
                },
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
