# coding: utf-8

"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

import unittest

import unit_test_api
from unit_test_api.components.schema.a_schema_given_for_prefixitems import ASchemaGivenForPrefixitems
from unit_test_api.configurations import schema_configuration


class TestASchemaGivenForPrefixitems(unittest.TestCase):
    """ASchemaGivenForPrefixitems unit test stubs"""
    configuration = schema_configuration.SchemaConfiguration(
        disabled_json_schema_keywords={'format'}
    )

    def test_incomplete_array_of_items_passes(self):
        # incomplete array of items
        ASchemaGivenForPrefixitems.validate(
            [
                1,
            ],
            configuration=self.configuration
        )

    def test_array_with_additional_items_passes(self):
        # array with additional items
        ASchemaGivenForPrefixitems.validate(
            [
                1,
                "foo",
                True,
            ],
            configuration=self.configuration
        )

    def test_empty_array_passes(self):
        # empty array
        ASchemaGivenForPrefixitems.validate(
            [
            ],
            configuration=self.configuration
        )

    def test_correct_types_passes(self):
        # correct types
        ASchemaGivenForPrefixitems.validate(
            [
                1,
                "foo",
            ],
            configuration=self.configuration
        )

    def test_javascript_pseudo_array_is_valid_passes(self):
        # JavaScript pseudo-array is valid
        ASchemaGivenForPrefixitems.validate(
            {
                "0":
                    "invalid",
                "1":
                    "valid",
                "length":
                    2,
            },
            configuration=self.configuration
        )

    def test_wrong_types_fails(self):
        # wrong types
        with self.assertRaises((unit_test_api.ApiValueError, unit_test_api.ApiTypeError)):
            ASchemaGivenForPrefixitems.validate(
                [
                    "foo",
                    1,
                ],
                configuration=self.configuration
            )


if __name__ == '__main__':
    unittest.main()
