# coding: utf-8
"""
    openapi 3.1.0 sample spec
    sample spec for testing openapi functionality, built from json schema tests for draft2020-12  # noqa: E501
    The version of the OpenAPI document: 0.0.1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
import abc
import dataclasses
import typing

from unit_test_api.schemas import validation, schema


@dataclasses.dataclass
class ServerWithoutVariables(abc.ABC):
    url: str


@dataclasses.dataclass
class ServerWithVariables(abc.ABC):
    _url: str
    variables: validation.immutabledict[str, str]
    variables_schema: typing.Type[schema.Schema]
    url: str = dataclasses.field(init=False)

    def __post_init__(self):
        url = self._url
        assert isinstance (self.variables, self.variables_schema().type_to_output_cls[validation.immutabledict])
        for (key, value) in self.variables.items():
            url = url.replace("{" + key + "}", value)
        self.url = url
