package org.openapijsonschematools.client.schemas.validation

import org.openapijsonschematools.client.exceptions.InvalidAdditionalPropertyException

class MapUtils {
    companion object {
        @Throws(InvalidAdditionalPropertyException::class)
        fun throwIfKeyKnown(key: String, knownKeys: Set<String>, setting: Boolean) {
            if (knownKeys.contains(key)) {
                var verb = "getting"
                if (setting) {
                    verb = "setting"
                }
                throw InvalidAdditionalPropertyException("The known key $key may not be passed in when $verb an additional property")
            }
        }
    }
}