package org.openapijsonschematools.client.schemas.validation

import org.openapijsonschematools.client.exceptions.ValidationException

class DependentRequiredValidator : KeywordValidator {
    @Throws(ValidationException::class)
    override fun validate(
        data: ValidationData
    ): PathToSchemasMap? {
        if (data.arg !is Map<*, *>) {
            return null
        }
        val dependentRequired: Map<String, Set<String>> = data.schema.dependentRequired ?: return null
        for ((key, value) in dependentRequired.entries) {
            if (!data.arg.containsKey(key)) {
                continue
            }
            val missingKeys: MutableSet<String> = HashSet(value)
            for (objKey in data.arg.keys) {
                if (objKey is String) {
                    missingKeys.remove(objKey)
                }
            }
            if (missingKeys.isEmpty()) {
                continue
            }
            throw ValidationException("""
                |Validation failed for dependentRequired because these_keys=$missingKeys are
                | missing at pathToItem=${data.validationMetadata.pathToItem} in class
                | ${data.schema.javaClass}
                """.trimMargin()
            )
        }
        return null
    }
}